/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.agl.converters.CharToByteConverterICU;
import com.adobe.agl.text.UTF16;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public final class Cmap
extends Table {
    protected final int unicodeSubtableOffset;
    protected final int oldUnicodeSubtableOffset;
    protected final NonUnicodeCmap[] nonUnicodeSubtableIndices;
    protected final int symbolSubtableOffset;
    protected int paddingByte = 0;

    protected Cmap(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
        int n = this.probe(3, 10);
        this.unicodeSubtableOffset = n != -1 ? n : ((n = this.probe(0, 4)) != -1 ? n : ((n = this.probe(3, 1)) != -1 ? n : ((n = this.probe(0, 3)) != -1 ? n : ((n = this.probe(0, 2)) != -1 ? n : -1))));
        n = this.probe(0, 1);
        this.oldUnicodeSubtableOffset = n != -1 ? n : ((n = this.probe(0, 0)) != -1 ? n : -1);
        n = this.probe(3, 0);
        if (n != -1) {
            this.symbolSubtableOffset = n;
            this.paddingByte = this.computeSymbolPad(this.symbolSubtableOffset);
        } else {
            this.symbolSubtableOffset = -1;
        }
        ArrayList<NonUnicodeCmap> arrayList = new ArrayList<NonUnicodeCmap>();
        n = this.probe(3, 2);
        if (n != -1) {
            arrayList.add(new NonUnicodeCmap(n, "windows-932"));
        }
        if ((n = this.probe(3, 3)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "windows-936"));
        }
        if ((n = this.probe(3, 4)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "windows-950"));
        }
        if ((n = this.probe(3, 5)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "windows-949"));
        }
        if ((n = this.probe(3, 6)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "ms1361"));
        }
        if ((n = this.probe(1, 0)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacRoman"));
        }
        if ((n = this.probe(1, 1)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacJapanese"));
        }
        if ((n = this.probe(1, 2)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacChineseTraditional"));
        }
        if ((n = this.probe(1, 3)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacKorean"));
        }
        if ((n = this.probe(1, 4)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacArabic"));
        }
        if ((n = this.probe(1, 5)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacHebrew"));
        }
        if ((n = this.probe(1, 6)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacGreek"));
        }
        if ((n = this.probe(1, 7)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacCyrillic"));
        }
        if ((n = this.probe(1, 8)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacSymbol"));
        }
        if ((n = this.probe(1, 21)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacThai"));
        }
        if ((n = this.probe(1, 25)) != -1) {
            arrayList.add(new NonUnicodeCmap(n, "MacChineseSimplified"));
        }
        this.nonUnicodeSubtableIndices = arrayList.toArray(new NonUnicodeCmap[0]);
    }

    private int computeSymbolPad(int n) throws UnsupportedFontException, InvalidFontException {
        int[] nArray = new int[]{61440, 61696, 61952, 0};
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = this.getMapping(n, 97 + nArray[i]);
            if (n2 == 0) continue;
            return nArray[i];
        }
        return nArray[0];
    }

    public int probe(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        int n3 = this.data.getuint16(2);
        for (int i = 0; i < n3; ++i) {
            int n4 = this.data.getuint16(4 + 8 * i + 0);
            int n5 = this.data.getuint16(4 + 8 * i + 2);
            if (n4 != n || n5 != n2) continue;
            return this.data.getuint32asint(4 + 8 * i + 4, "Offset to cmap subtable is big");
        }
        return -1;
    }

    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException {
        return this.symbolSubtableOffset != -1;
    }

    public void enumerateCmaps(CmapSelector cmapSelector) throws UnsupportedFontException, InvalidFontException {
        int n = this.data.getuint16(2);
        block14: for (int i = 0; i < n; ++i) {
            int n2 = this.data.getuint16(4 + 8 * i + 0);
            int n3 = this.data.getuint16(4 + 8 * i + 2);
            switch (n2) {
                case 1: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 21: 
                        case 25: {
                            cmapSelector.cmapFound(n2, n3, i);
                        }
                    }
                    continue block14;
                }
                case 3: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 10: {
                            cmapSelector.cmapFound(n2, n3, i);
                        }
                    }
                    continue block14;
                }
                case 0: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            cmapSelector.cmapFound(n2, n3, i);
                        }
                    }
                }
            }
        }
    }

    public int getCmapSubtableIndex(int n, int n2) throws InvalidFontException {
        int n3 = this.data.getuint16(2);
        for (int i = 0; i < n3; ++i) {
            int n4 = this.data.getuint16(4 + 8 * i + 0);
            int n5 = this.data.getuint16(4 + 8 * i + 2);
            if (n4 != n || n5 != n2) continue;
            return i;
        }
        return -1;
    }

    int removeSymbolModifier(int n) throws UnsupportedFontException, InvalidFontException {
        int n2;
        if (this.symbolSubtableOffset != -1 && (n2 = n & 0xFF00) == this.paddingByte) {
            return n & 0xFF;
        }
        return n;
    }

    public int unicodeChar2glyph(int n) throws UnsupportedFontException, InvalidFontException {
        if (this.symbolSubtableOffset != -1) {
            int n2 = this.getMapping(this.symbolSubtableOffset, n);
            if (n2 == 0 && 0 <= n && n <= 255) {
                n2 = this.getMapping(this.symbolSubtableOffset, this.paddingByte | n);
            }
            return n2;
        }
        if (this.unicodeSubtableOffset != -1) {
            if (n == 65535) {
                return 0;
            }
            return this.getMapping(this.unicodeSubtableOffset, n);
        }
        if (this.nonUnicodeSubtableIndices != null) {
            return this.getNonUnicodeMapping(n);
        }
        return 0;
    }

    public int coolTypeUnicodeChar2glyph(int n) throws UnsupportedFontException, InvalidFontException {
        if (this.unicodeSubtableOffset != -1) {
            return this.getMapping(this.unicodeSubtableOffset, n);
        }
        if (this.oldUnicodeSubtableOffset != -1) {
            return this.getMapping(this.oldUnicodeSubtableOffset, n);
        }
        if (this.symbolSubtableOffset != -1) {
            int n2 = this.getMapping(this.symbolSubtableOffset, n);
            if (n2 == 0 && 0 <= n && n <= 255) {
                n2 = this.getMapping(this.symbolSubtableOffset, this.paddingByte | n);
            }
            return n2;
        }
        if (this.nonUnicodeSubtableIndices != null) {
            return this.getNonUnicodeMapping(n);
        }
        return 0;
    }

    int getNonUnicodeMapping(int n) throws UnsupportedFontException, InvalidFontException {
        char[] cArray = new char[2];
        int n2 = UTF16.append((char[])cArray, (int)0, (int)n);
        byte[] byArray = new byte[10];
        for (int i = 0; i < this.nonUnicodeSubtableIndices.length; ++i) {
            try {
                int n3;
                CharToByteConverterICU charToByteConverterICU = this.nonUnicodeSubtableIndices[i].getConverter();
                if (charToByteConverterICU == null) {
                    n3 = this.getMapping(this.nonUnicodeSubtableIndices[i].subtableOffset, n);
                    if (n3 == 0) continue;
                    return n3;
                }
                if (!charToByteConverterICU.canConvert(n)) continue;
                n3 = charToByteConverterICU.convert(cArray, 0, n2, byArray, 0, byArray.length);
                if ((n3 += charToByteConverterICU.flush(byArray, n3, byArray.length)) == 1) {
                    int n4 = byArray[0] & 0xFF;
                    return this.getMapping(this.nonUnicodeSubtableIndices[i].subtableOffset, n4);
                }
                if (n3 != 2) continue;
                int n5 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
                return this.getMapping(this.nonUnicodeSubtableIndices[i].subtableOffset, n5);
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                continue;
            }
            catch (UnknownCharacterException unknownCharacterException) {
                continue;
            }
            catch (MalformedInputException malformedInputException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int char2glyph(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3 = this.data.getuint32asint(4 + 8 * n2 + 4, "Offset to cmap subtable is big");
        return this.getMapping(n3, n);
    }

    public int getLowestMappedCode(int n) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint16(n);
        switch (n2) {
            case 0: {
                return this.getLowestMappedCodeFormat0(n);
            }
            case 2: {
                return this.getLowestMappedCodeFormat2(n);
            }
            case 4: {
                return this.getLowestMappedCodeFormat4(n);
            }
            case 6: {
                return this.getLowestMappedCodeFormat6(n);
            }
            case 8: {
                return this.getLowestMappedCodeFormat8(n);
            }
            case 10: {
                return this.getLowestMappedCodeFormat10(n);
            }
            case 12: {
                return this.getLowestMappedCodeFormat12(n);
            }
        }
        throw new UnsupportedFontException("cmap subtable format " + n2);
    }

    public int getHighestMappedCode(int n, boolean bl) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint16(n);
        switch (n2) {
            case 0: {
                return this.getHighestMappedCodeFormat0(n);
            }
            case 2: {
                return this.getHighestMappedCodeFormat2(n);
            }
            case 4: {
                return this.getHighestMappedCodeFormat4(n);
            }
            case 6: {
                return this.getHighestMappedCodeFormat6(n);
            }
            case 8: {
                return this.getHighestMappedCodeFormat8(n, bl);
            }
            case 10: {
                return this.getHighestMappedCodeFormat10(n, bl);
            }
            case 12: {
                return this.getHighestMappedCodeFormat12(n, bl);
            }
        }
        throw new UnsupportedFontException("cmap subtable format " + n2);
    }

    public int getMapping(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3 = this.data.getuint16(n);
        switch (n3) {
            case 0: {
                return this.getMappingFormat0(n, n2);
            }
            case 2: {
                return this.getMappingFormat2(n, n2);
            }
            case 4: {
                return this.getMappingFormat4(n, n2);
            }
            case 6: {
                return this.getMappingFormat6(n, n2);
            }
            case 8: {
                return this.getMappingFormat8(n, n2);
            }
            case 10: {
                return this.getMappingFormat10(n, n2);
            }
            case 12: {
                return this.getMappingFormat12(n, n2);
            }
        }
        throw new UnsupportedFontException("cmap subtable format " + n3);
    }

    public int[] glyph2char(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3;
        int[] nArray = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3] = -1;
        }
        n3 = this.data.getuint32asint(4 + 8 * n2 + 4, "Offset to cmap subtable is big");
        int n4 = this.data.getuint16(n3);
        switch (n4) {
            case 0: {
                this.getInvertedMappingFormat0(nArray, n3);
                break;
            }
            case 2: {
                this.getInvertedMappingFormat2(nArray, n3);
                break;
            }
            case 4: {
                this.getInvertedMappingFormat4(nArray, n3);
                break;
            }
            case 6: {
                this.getInvertedMappingFormat6(nArray, n3);
                break;
            }
            case 8: {
                this.getInvertedMappingFormat8(nArray, n3);
                break;
            }
            case 10: {
                this.getInvertedMappingFormat10(nArray, n3);
                break;
            }
            case 12: {
                this.getInvertedMappingFormat12(nArray, n3);
                break;
            }
            default: {
                throw new UnsupportedFontException("cmap subtable format " + n4);
            }
        }
        return nArray;
    }

    protected int getLowestMappedCodeFormat0(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 2) - 6 - 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.data.getuint8(n + 6 + i);
            if (n3 <= 0) continue;
            return i;
        }
        return n2;
    }

    protected int getHighestMappedCodeFormat0(int n) throws InvalidFontException {
        for (int i = this.data.getuint16(n + 2) - 6 - 1; i >= 0; --i) {
            int n2 = this.data.getuint8(n + 6 + i);
            if (n2 <= 0) continue;
            return i;
        }
        return 0;
    }

    protected int getMappingFormat0(int n, int n2) throws InvalidFontException {
        int n3 = this.data.getuint16(n + 2) - 6;
        if (0 <= n2 && n2 < n3) {
            return this.data.getuint8(n + 6 + n2);
        }
        return 0;
    }

    protected void getInvertedMappingFormat0(int[] nArray, int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 2) - 6;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.data.getuint8(n + 6 + n3);
            nArray[n4] = n3++;
        }
    }

    protected int getLowestMappedCodeFormat2(int n) throws InvalidFontException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        for (n10 = 0; n10 <= 255; ++n10) {
            n9 = this.data.getuint16(n + 6 + 2 * n10) / 8;
            n8 = n + 518 + 8 * n9;
            n7 = this.data.getuint16(n8);
            n6 = this.data.getuint16(n8 + 2) + n7 - 1;
            if (n7 > n10 || n10 > n6) continue;
            n5 = this.data.getuint16(n8 + 4);
            n4 = this.data.getuint16(n8 + 6);
            n3 = n8 + 6 + n4;
            n2 = this.data.getuint16(n3 + 2 * (n10 - n7));
            if (n2 == 0 || (n2 = (n2 + n5) % 65536) == 0) continue;
            return n10;
        }
        for (n10 = 1; n10 <= 255; ++n10) {
            n9 = this.data.getuint16(n + 6 + 2 * n10) / 8;
            n8 = n + 518 + 8 * n9;
            n6 = n7 = this.data.getuint16(n8);
            n5 = this.data.getuint16(n8 + 2) + n7 - 1;
            while (n7 <= n5) {
                n4 = this.data.getuint16(n8 + 4);
                n3 = this.data.getuint16(n8 + 6);
                n2 = n8 + 6 + n3;
                int n11 = this.data.getuint16(n2 + 2 * (n7 - n6));
                if (n11 != 0 && (n11 = (n11 + n4) % 65536) != 0) {
                    return n10 << 8 | n7;
                }
                ++n7;
            }
        }
        return 0;
    }

    protected int getHighestMappedCodeFormat2(int n) throws InvalidFontException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        for (n10 = 255; n10 > 0; --n10) {
            n9 = this.data.getuint16(n + 6 + 2 * n10) / 8;
            n8 = n + 518 + 8 * n9;
            n7 = this.data.getuint16(n8);
            for (n6 = this.data.getuint16(n8 + 2) + n7 - 1; n7 <= n6; --n6) {
                n5 = this.data.getuint16(n8 + 4);
                n4 = this.data.getuint16(n8 + 6);
                n3 = n8 + 6 + n4;
                n2 = this.data.getuint16(n3 + 2 * (n6 - n7));
                if (n2 == 0 || (n2 = (n2 + n5) % 65536) == 0) continue;
                return n10 << 8 | n6;
            }
        }
        for (n10 = 255; n10 >= 0; --n10) {
            n9 = this.data.getuint16(n + 6 + 2 * n10) / 8;
            n8 = n + 518 + 8 * n9;
            n7 = this.data.getuint16(n8);
            n6 = this.data.getuint16(n8 + 2) + n7 - 1;
            if (n7 > n10 || n10 > n6) continue;
            n5 = this.data.getuint16(n8 + 4);
            n4 = this.data.getuint16(n8 + 6);
            n3 = n8 + 6 + n4;
            n2 = this.data.getuint16(n3 + 2 * (n10 - n7));
            if (n2 == 0 || (n2 = (n2 + n5) % 65536) == 0) continue;
            return n10;
        }
        return 0;
    }

    protected int getMappingFormat2(int n, int n2) throws InvalidFontException {
        int n3 = n2 >> 8 & 0xFF;
        int n4 = n2 & 0xFF;
        int n5 = n3 == 0 && this.data.getuint16(n + 6 + 2 * n4) == 0 ? n4 : n3;
        int n6 = n4;
        n3 = this.data.getuint16(n + 6 + 2 * n5) / 8;
        n4 = n + 518 + 8 * n3;
        int n7 = this.data.getuint16(n4);
        int n8 = this.data.getuint16(n4 + 2);
        if (n6 < n7 || n7 + n8 <= n6) {
            return 0;
        }
        int n9 = this.data.getuint16(n4 + 4);
        int n10 = this.data.getuint16(n4 + 6);
        int n11 = n4 + 6 + n10;
        int n12 = this.data.getuint16(n11 + 2 * (n6 - n7));
        if (n12 == 0) {
            return 0;
        }
        return (n12 + n9) % 65536;
    }

    protected void getInvertedMappingFormat2(int[] nArray, int n) throws InvalidFontException {
        for (int i = 0; i <= 255; ++i) {
            int n2;
            int n3 = this.data.getuint16(n + 6 + 2 * i) / 8;
            int n4 = n + 518 + n3 * 8;
            int n5 = this.data.getuint16(n4);
            int n6 = this.data.getuint16(n4 + 2);
            int n7 = this.data.getuint16(n4 + 4);
            int n8 = this.data.getuint16(n4 + 6);
            int n9 = n4 + 6 + n8;
            if (n3 == 0) {
                n2 = this.data.getuint16(n9 + 2 * (i - n5));
                if (n2 == 0) continue;
                nArray[(n2 + n7) % 65536] = i;
                continue;
            }
            for (n2 = n5; n2 < n5 + n6; ++n2) {
                int n10 = this.data.getuint16(n9 + 2 * (n2 - n5));
                if (n10 == 0) continue;
                nArray[(n10 + n7) % 65536] = (i << 8) + n2;
            }
        }
    }

    protected int getLowestMappedCodeFormat4(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 6) / 2;
        int n3 = n2 - 1;
        for (n3 = 0; n3 <= n2 - 1; ++n3) {
            try {
                int n4;
                int n5 = n4 = this.data.getuint16(n + 16 + 2 * n2 + 2 * n3);
                int n6 = this.data.getuint16(n + 14 + 2 * n3);
                while (n4 <= n6) {
                    try {
                        int n7;
                        int n8;
                        int n9 = this.data.getuint16(n + 16 + 6 * n2 + 2 * n3);
                        int n10 = this.data.getint16(n + 16 + 4 * n2 + 2 * n3);
                        if (n9 == 0 && (n8 = n4 + n10 & 0xFFFF) != 0) {
                            return n4;
                        }
                        n8 = n + 16 + 6 * n2 + 2 * n3 + n9 + 2 * (n4 - n5);
                        int n11 = this.data.getuint16(n8);
                        if (n11 != 0 && (n7 = n11 + n10 & 0xFFFF) != 0) {
                            return n4;
                        }
                    }
                    catch (InvalidFontException invalidFontException) {
                        // empty catch block
                    }
                    ++n4;
                }
                continue;
            }
            catch (InvalidFontException invalidFontException) {
                // empty catch block
            }
        }
        return 0;
    }

    protected int getHighestMappedCodeFormat4(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 6) / 2;
        for (int i = n2 - 1; 0 <= i; --i) {
            try {
                int n3 = this.data.getuint16(n + 16 + 2 * n2 + 2 * i);
                for (int j = this.data.getuint16(n + 14 + 2 * i); j >= n3; --j) {
                    try {
                        int n4;
                        int n5;
                        int n6 = this.data.getuint16(n + 16 + 6 * n2 + 2 * i);
                        int n7 = this.data.getint16(n + 16 + 4 * n2 + 2 * i);
                        if (n6 == 0 && (n5 = j + n7 & 0xFFFF) != 0) {
                            return j;
                        }
                        n5 = n + 16 + 6 * n2 + 2 * i + n6 + 2 * (j - n3);
                        int n8 = this.data.getuint16(n5);
                        if (n8 == 0 || (n4 = n8 + n7 & 0xFFFF) == 0) continue;
                        return j;
                    }
                    catch (InvalidFontException invalidFontException) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (InvalidFontException invalidFontException) {
                // empty catch block
            }
        }
        return 0;
    }

    protected int getMappingFormat4(int n, int n2) {
        try {
            int n3 = this.data.getuint16(n + 6) / 2;
            int n4 = 0;
            int n5 = n3 - 1;
            while (n4 <= n5) {
                int n6 = (n4 + n5) / 2;
                int n7 = this.data.getuint16(n + 16 + 2 * n3 + 2 * n6);
                int n8 = this.data.getuint16(n + 14 + 2 * n6);
                if (n2 < n7) {
                    n5 = n6 - 1;
                    continue;
                }
                if (n8 < n2) {
                    n4 = n6 + 1;
                    continue;
                }
                int n9 = this.data.getuint16(n + 16 + 6 * n3 + 2 * n6);
                int n10 = this.data.getint16(n + 16 + 4 * n3 + 2 * n6);
                if (n9 == 0) {
                    return n2 + n10 & 0xFFFF;
                }
                int n11 = n + 16 + 6 * n3 + 2 * n6 + n9 + 2 * (n2 - n7);
                int n12 = this.data.getuint16(n11);
                if (n12 == 0) {
                    return 0;
                }
                return n12 + n10 & 0xFFFF;
            }
            return 0;
        }
        catch (InvalidFontException invalidFontException) {
            return 0;
        }
    }

    protected void getInvertedMappingFormat4(int[] nArray, int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 6) / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.data.getuint16(n + 16 + 2 * n2 + 2 * i);
            int n4 = this.data.getuint16(n + 14 + 2 * i);
            int n5 = n + 16 + 6 * n2 + 2 * i;
            int n6 = this.data.getuint16(n5);
            int n7 = this.data.getint16(n + 16 + 4 * n2 + 2 * i);
            for (int j = n3; j <= n4; ++j) {
                int n8;
                int n9;
                if (n6 == 0) {
                    n9 = j + n7 & 0xFFFF;
                    if (n9 == 0 || n9 >= nArray.length) continue;
                    nArray[n9] = j;
                    continue;
                }
                n9 = n + 16 + 6 * n2 + 2 * i + n6 + 2 * (j - n3);
                int n10 = this.data.getuint16(n9);
                if (n10 == 0 || (n8 = n10 + n7 & 0xFFFF) == 0 || n8 >= nArray.length) continue;
                nArray[n8] = j;
            }
        }
    }

    protected int getLowestMappedCodeFormat6(int n) throws InvalidFontException {
        int n2;
        int n3 = n2 = this.data.getuint16(n + 6);
        int n4 = this.data.getuint16(n + 8) + n2 - 1;
        while (n2 <= n4) {
            int n5 = this.data.getuint16(n + 10 + (n2 - n3) * 2);
            if (n5 != 0) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    protected int getHighestMappedCodeFormat6(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 6);
        for (int i = this.data.getuint16(n + 8) + n2 - 1; n2 <= i; --i) {
            int n3 = this.data.getuint16(n + 10 + (i - n2) * 2);
            if (n3 == 0) continue;
            return i;
        }
        return 0;
    }

    protected int getMappingFormat6(int n, int n2) throws InvalidFontException {
        int n3 = this.data.getuint16(n + 6);
        int n4 = this.data.getuint16(n + 8);
        if (n3 <= n2 && n2 < n3 + n4) {
            return this.data.getuint16(n + 10 + (n2 - n3) * 2);
        }
        return 0;
    }

    protected void getInvertedMappingFormat6(int[] nArray, int n) throws InvalidFontException {
        int n2 = this.data.getuint16(n + 6);
        int n3 = this.data.getuint16(n + 8);
        for (int i = 0; i < n3; ++i) {
            int n4;
            nArray[this.data.getuint16((int)(n + 10 + i * 2))] = n4 = n2 + i;
        }
    }

    protected int getLowestMappedCodeFormat8(int n) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint32asint(n + 8204, "cmap subtable, format 8, nGroups is big");
        int n3 = 65535;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.data.getuint32asint(n + 8208 + 12 * i, "cmap subtable, format 8, startCharCode is big");
            n3 = this.data.getuint32asint(n + 8208 + 12 * i + 4, "cmap subtable, format 8, endCharCode is big");
            for (int j = n4; j <= n3; ++j) {
                int n5 = this.data.getuint32asint(n + 8208 + 12 * i + 8, "cmap subtable, format 8, startGlyphID is big") + j - n4;
                if (n5 == 0 || j > 65535) continue;
                return j;
            }
        }
        return n3;
    }

    protected int getHighestMappedCodeFormat8(int n, boolean bl) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint32asint(n + 8204, "cmap subtable, format 8, nGroups is big");
        for (int i = n2 - 1; 0 <= i; --i) {
            int n3 = this.data.getuint32asint(n + 8208 + 12 * i, "cmap subtable, format 8, startCharCode is big");
            for (int j = this.data.getuint32asint(n + 8208 + 12 * i + 4, "cmap subtable, format 8, endCharCode is big"); j >= n3; --j) {
                int n4 = this.data.getuint32asint(n + 8208 + 12 * i + 8, "cmap subtable, format 8, startGlyphID is big") + j - n3;
                if (n4 == 0 || bl && j > 65535) continue;
                return j;
            }
        }
        return 0;
    }

    protected int getMappingFormat8(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3 = this.data.getuint32asint(n + 8204, "cmap subtable, format 8, nGroups is big");
        int n4 = 0;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = (n4 + n5) / 2;
            int n7 = this.data.getuint32asint(n + 8208 + 12 * n6, "cmap subtable, format 8, startCharCode is big");
            int n8 = this.data.getuint32asint(n + 8208 + 12 * n6 + 4, "cmap subtable, format 8, endCharCode is big");
            if (n2 < n7) {
                n5 = n6 - 1;
                continue;
            }
            if (n8 < n2) {
                n4 = n6 + 1;
                continue;
            }
            int n9 = this.data.getuint32asint(n + 8208 + 12 * n6 + 8, "cmap subtable, format 8, startGlyphID is big");
            return n2 - n7 + n9;
        }
        return 0;
    }

    protected void getInvertedMappingFormat8(int[] nArray, int n) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint32asint(n + 8204, "cmap subtable, format 8, nGroups is big");
        for (int i = 0; i < n2; ++i) {
            int n3 = this.data.getuint32asint(n + 8208 + 12 * i, "cmap subtable, format 8, startCharCode is big");
            int n4 = this.data.getuint32asint(n + 8208 + 12 * i + 4, "cmap subtable, format 8, endCharCode is big");
            int n5 = this.data.getuint32asint(n + 8208 + 12 * i + 8, "cmap subtable, format 8, startGlyphID is big");
            for (int j = n3; j <= n4; ++j) {
                nArray[n5 + j - n3] = j;
            }
        }
    }

    protected int getLowestMappedCodeFormat10(int n) throws InvalidFontException, UnsupportedFontException {
        int n2 = this.data.getuint32asint(n + 12, "cmap subtable, format 10, startCharCode is big");
        int n3 = this.data.getuint32asint(n + 16, "cmap subtable, format 10, numChars is big") + n2 - 1;
        for (int i = n2; i <= n3; ++i) {
            int n4 = this.data.getuint16(n + 20 + 2 * (i - n2));
            if (n4 <= 0) continue;
            return i;
        }
        return n3;
    }

    protected int getHighestMappedCodeFormat10(int n, boolean bl) throws InvalidFontException, UnsupportedFontException {
        int n2 = this.data.getuint32asint(n + 12, "cmap subtable, format 10, startCharCode is big");
        int n3 = this.data.getuint32asint(n + 16, "cmap subtable, format 10, numChars is big");
        for (int i = n2 + n3 - 1; n2 <= i; --i) {
            int n4 = this.data.getuint16(n + 20 + 2 * (i - n2));
            if (n4 <= 0 || bl && i > 65535) continue;
            return i;
        }
        return 0;
    }

    protected int getMappingFormat10(int n, int n2) throws UnsupportedFontException, InvalidFontException {
        int n3 = this.data.getuint32asint(n + 12, "cmap subtable, format 10, startCharCode is big");
        int n4 = this.data.getuint32asint(n + 16, "cmap subtable, format 10, numChars is big");
        if (n3 <= n2 && n2 < n3 + n4) {
            return this.data.getuint16(n + 20 + 2 * (n2 - n3));
        }
        return 0;
    }

    protected void getInvertedMappingFormat10(int[] nArray, int n) throws UnsupportedFontException, InvalidFontException {
        int n2 = this.data.getuint32asint(n + 12, "cmap subtable, format 10, startCharCode is big");
        int n3 = this.data.getuint32asint(n + 16, "cmap subtable, format 10, numChars is big");
        for (int i = n2; i < n2 + n3; ++i) {
            nArray[this.data.getuint16((int)(n + 20 + 2 * (i - n2)))] = i;
        }
    }

    protected int getLowestMappedCodeFormat12(int n) throws InvalidFontException, UnsupportedFontException {
        int n2 = (int)this.data.getuint32(n + 12);
        int n3 = 65535;
        for (int i = 0; i < n2; ++i) {
            int n4 = (int)this.data.getuint32(n + 16 + 12 * i);
            n3 = (int)this.data.getuint32(n + 16 + 12 * i + 4);
            for (int j = n4; j <= n3; ++j) {
                int n5 = (int)this.data.getuint32(n + 16 + 12 * i + 8);
                if ((n5 += j - n4) <= 0) continue;
                return j;
            }
        }
        return n3;
    }

    protected int getHighestMappedCodeFormat12(int n, boolean bl) throws InvalidFontException, UnsupportedFontException {
        int n2 = (int)this.data.getuint32(n + 12);
        for (int i = n2 - 1; 0 <= i; --i) {
            int n3 = (int)this.data.getuint32(n + 16 + 12 * i);
            for (int j = (int)this.data.getuint32(n + 16 + 12 * i + 4); j >= n3; --j) {
                int n4 = (int)this.data.getuint32(n + 16 + 12 * i + 8);
                if ((n4 += j - n3) <= 0 || bl && j > 65535) continue;
                return j;
            }
        }
        return 0;
    }

    protected int getMappingFormat12(int n, int n2) throws InvalidFontException {
        int n3 = (int)this.data.getuint32(n + 12);
        int n4 = 0;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = (n4 + n5) / 2;
            int n7 = (int)this.data.getuint32(n + 16 + 12 * n6);
            int n8 = (int)this.data.getuint32(n + 16 + 12 * n6 + 4);
            if (n2 < n7) {
                n5 = n6 - 1;
                continue;
            }
            if (n8 < n2) {
                n4 = n6 + 1;
                continue;
            }
            int n9 = (int)this.data.getuint32(n + 16 + 12 * n6 + 8);
            return n9 + (n2 - n7);
        }
        return 0;
    }

    protected void getInvertedMappingFormat12(int[] nArray, int n) throws InvalidFontException {
        int n2 = (int)this.data.getuint32(n + 12);
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)this.data.getuint32(n + 16 + 12 * i);
            int n4 = (int)this.data.getuint32(n + 16 + 12 * i + 4);
            int n5 = (int)this.data.getuint32(n + 16 + 12 * i + 8);
            for (int j = n3; j <= n4; ++j) {
                nArray[n5 + (j - n3)] = j;
            }
        }
    }

    public void subsetAndStream(Subset subset, SubsetSimpleTrueType subsetSimpleTrueType, Map map) throws UnsupportedFontException, InvalidFontException {
        int n;
        int n2;
        int n3;
        if (subsetSimpleTrueType == null) {
            return;
        }
        int n4 = subsetSimpleTrueType.getCmap();
        int n5 = this.data.getuint16(n4);
        if (n5 != 0 && n5 != 4 && n5 != 12) {
            throw new UnsupportedFontException("Unsupported cmap format");
        }
        if (n5 == 12) {
            n5 = 4;
        }
        ArrayList<MapElement> arrayList = new ArrayList<MapElement>();
        int n6 = this.offsetToIndex(n4);
        int[] nArray = subsetSimpleTrueType.getCodePoints();
        for (int i = 0; i < nArray.length; ++i) {
            n3 = nArray[i];
            int n7 = this.char2glyph(n3, n6);
            n2 = subset.getExistingSubsetGid(n7);
            if (n2 <= 0) {
                throw new InvalidFontException("Subset does not contain required codepoint");
            }
            MapElement mapElement = new MapElement(n3, n2);
            arrayList.add(mapElement);
        }
        if (arrayList.size() == 0) {
            return;
        }
        MapElement mapElement = (MapElement)arrayList.get(0);
        if (mapElement.mCodePoint > 65535) {
            n5 = 12;
        }
        n3 = 1;
        while (n3 < arrayList.size()) {
            MapElement mapElement2 = (MapElement)arrayList.get(n3);
            if (mapElement2.mCodePoint == mapElement.mCodePoint) {
                arrayList.remove(n3);
                continue;
            }
            if (mapElement2.mCodePoint > 65535) {
                n5 = 12;
            }
            mapElement = mapElement2;
            ++n3;
        }
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(Math.max(1024, arrayList.size() * 32));
        oTByteArrayBuilder.setuint16(0, 0);
        oTByteArrayBuilder.setuint16(2, 1);
        int n8 = 4;
        n2 = this.data.getuint16(4 + 8 * n6 + 0);
        int n9 = this.data.getuint16(4 + 8 * n6 + 2);
        if (n4 == this.probe(3, 1)) {
            n2 = 3;
            n9 = 1;
        }
        oTByteArrayBuilder.setuint16(n8, n2);
        oTByteArrayBuilder.setuint16(n8 + 2, n9);
        oTByteArrayBuilder.setuint32(n8 + 4, n8 + 8);
        int n10 = n8 += 8;
        ArrayList<MapSegment> arrayList2 = new ArrayList<MapSegment>();
        int n11 = 0;
        mapElement = (MapElement)arrayList.get(n11);
        if (n5 == 0) {
            oTByteArrayBuilder.setuint16(n8, 0);
            oTByteArrayBuilder.setuint16(n8 + 2, 262);
            oTByteArrayBuilder.setuint16(n8 + 4, 0);
            oTByteArrayBuilder.setuint8((n8 += 6) + 255, 0);
            for (int i = 0; i < arrayList.size(); ++i) {
                MapElement mapElement3 = (MapElement)arrayList.get(i);
                oTByteArrayBuilder.setuint8(n8 + mapElement3.mCodePoint, mapElement3.mGlyphID);
            }
        } else if (n5 == 4) {
            MapElement mapElement4;
            MapSegment mapSegment;
            int n12 = 0;
            if (((MapElement)arrayList.get((int)(arrayList.size() - 1))).mCodePoint != 65535) {
                arrayList.add(new MapElement(65535, 0));
            }
            while (n < arrayList.size()) {
                MapElement mapElement5 = (MapElement)arrayList.get(n);
                if (mapElement5.mCodePoint == mapElement.mCodePoint + 1) {
                    if (mapElement5.mGlyphID == mapElement.mGlyphID + 1) {
                        if (++n12 > 3 && n12 < n - n11) {
                            arrayList2.add(new MapSegment(n11, n - n12, false));
                            n11 = n - n12;
                        }
                    } else {
                        if (n12 > 3) {
                            arrayList2.add(new MapSegment(n11, n, true));
                            n11 = n;
                        }
                        n12 = 0;
                    }
                } else {
                    arrayList2.add(new MapSegment(n11, n, n - n11 == n12 + 1));
                    n11 = n;
                    n12 = 0;
                }
                mapElement = mapElement5;
                ++n;
            }
            arrayList2.add(new MapSegment(n11, n, n - n11 == n12 + 1));
            oTByteArrayBuilder.setuint16(n8, 4);
            int n13 = arrayList2.size();
            oTByteArrayBuilder.setuint16(n8 + 4, 0);
            oTByteArrayBuilder.setuint16(n8 + 6, n13 * 2);
            int n14 = 0;
            while (n13 != 0) {
                n13 >>= 1;
                ++n14;
            }
            n13 = arrayList2.size();
            oTByteArrayBuilder.setuint16(n8 + 8, 1 << n14);
            oTByteArrayBuilder.setuint16(n8 + 10, n14 - 1);
            oTByteArrayBuilder.setuint16(n8 + 12, n13 * 2 - (1 << n14));
            n8 += 14;
            for (n6 = 0; n6 < n13; ++n6) {
                mapSegment = (MapSegment)arrayList2.get(n6);
                mapElement4 = (MapElement)arrayList.get(mapSegment.mEndIndex - 1);
                oTByteArrayBuilder.setuint16(n8 + n6 * 2, mapElement4.mCodePoint);
            }
            oTByteArrayBuilder.setuint16(n8 += n6 * 2, 0);
            n8 += 2;
            for (n6 = 0; n6 < n13; ++n6) {
                mapSegment = (MapSegment)arrayList2.get(n6);
                mapElement4 = (MapElement)arrayList.get(mapSegment.mFirstIndex);
                oTByteArrayBuilder.setuint16(n8 + n6 * 2, mapElement4.mCodePoint);
            }
            n8 += n6 * 2;
            for (n6 = 0; n6 < n13; ++n6) {
                mapSegment = (MapSegment)arrayList2.get(n6);
                n4 = 0;
                if (mapSegment.mOrdered) {
                    mapElement4 = (MapElement)arrayList.get(mapSegment.mFirstIndex);
                    n4 = mapElement4.mGlyphID - (short)mapElement4.mCodePoint;
                }
                oTByteArrayBuilder.setuint16(n8 + n6 * 2, n4);
            }
            int n15 = (n8 += n6 * 2) + n6 * 2;
            int n16 = 0;
            for (n6 = 0; n6 < n13; ++n6) {
                MapSegment mapSegment2 = (MapSegment)arrayList2.get(n6);
                n4 = 0;
                if (!mapSegment2.mOrdered) {
                    n4 = (n13 - n6 + n16) * 2;
                    for (int i = mapSegment2.mFirstIndex; i < mapSegment2.mEndIndex; ++i) {
                        MapElement mapElement6 = (MapElement)arrayList.get(i);
                        oTByteArrayBuilder.setuint16(n15 + n16 * 2, mapElement6.mGlyphID);
                        ++n16;
                    }
                }
                oTByteArrayBuilder.setuint16(n8 + n6 * 2, n4);
            }
            oTByteArrayBuilder.setuint16(n10 + 2, n15 + n16 * 2 - n10);
        } else {
            for (n = 1; n < arrayList.size(); ++n) {
                MapElement mapElement7 = (MapElement)arrayList.get(n);
                if (mapElement7.mCodePoint != mapElement.mCodePoint + 1 || mapElement7.mGlyphID != mapElement.mGlyphID + 1) {
                    arrayList2.add(new MapSegment(n11, n, true));
                    n11 = n;
                }
                mapElement = mapElement7;
            }
            arrayList2.add(new MapSegment(n11, n, true));
            int n17 = arrayList2.size();
            oTByteArrayBuilder.setuint16(n8, 12);
            oTByteArrayBuilder.setuint16(n8 + 2, 0);
            oTByteArrayBuilder.setuint32(n8 + 4, 16 + n17 * 12);
            oTByteArrayBuilder.setuint32(n8 + 8, 0);
            oTByteArrayBuilder.setuint32(n8 + 12, n17);
            n8 += 16;
            for (n6 = 0; n6 < n17; ++n6) {
                MapSegment mapSegment = (MapSegment)arrayList2.get(n6);
                MapElement mapElement8 = (MapElement)arrayList.get(mapSegment.mFirstIndex);
                MapElement mapElement9 = (MapElement)arrayList.get(mapSegment.mEndIndex - 1);
                oTByteArrayBuilder.setuint32(n8 + n6 * 12, mapElement8.mCodePoint);
                oTByteArrayBuilder.setuint32(n8 + n6 * 12 + 4, mapElement9.mCodePoint);
                oTByteArrayBuilder.setuint32(n8 + n6 * 12 + 8, mapElement8.mGlyphID);
            }
        }
        map.put(new Integer(1668112752), oTByteArrayBuilder);
    }

    int offsetToIndex(int n) throws InvalidFontException {
        int n2 = this.data.getuint16(2);
        for (int i = 0; i < n2; ++i) {
            if ((long)n != this.data.getuint32(4 + i * 8 + 4)) continue;
            return i;
        }
        return -1;
    }

    private final class MapSegment {
        int mFirstIndex;
        int mEndIndex;
        boolean mOrdered;

        MapSegment(int n, int n2, boolean bl) {
            this.mFirstIndex = n;
            this.mEndIndex = n2;
            this.mOrdered = bl;
        }
    }

    private final class MapElement
    implements Comparable {
        int mCodePoint;
        int mGlyphID;

        MapElement(int n, int n2) {
            this.mCodePoint = n;
            this.mGlyphID = n2;
        }

        public int compareTo(Object object) {
            return this.mCodePoint - ((MapElement)object).mCodePoint;
        }
    }

    static class NonUnicodeCmap {
        final int subtableOffset;
        final String charsetName;
        CharToByteConverterICU converter = null;

        public NonUnicodeCmap(int n, String string) {
            this.subtableOffset = n;
            this.charsetName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharToByteConverterICU getConverter() throws UnsupportedEncodingException {
            NonUnicodeCmap nonUnicodeCmap = this;
            synchronized (nonUnicodeCmap) {
                if (this.converter == null && this.charsetName != null) {
                    this.converter = new CharToByteConverterICU(this.charsetName);
                    this.converter.setSubstitutionMode(false);
                }
                return this.converter;
            }
        }
    }

    public static interface CmapSelector {
        public void cmapFound(int var1, int var2, int var3) throws InvalidFontException, UnsupportedFontException;
    }

    public static final class MacEncodingID {
        public static final int ROMAN = 0;
        public static final int JAPANESE = 1;
        public static final int CHINESE_TRADITIONAL = 2;
        public static final int KOREAN = 3;
        public static final int ARABIC = 4;
        public static final int HEBREW = 5;
        public static final int GREEK = 6;
        public static final int RUSSIAN = 7;
        public static final int RSYMBOL = 8;
        public static final int DEVANAGARI = 9;
        public static final int GURMUKHI = 10;
        public static final int GUJARATI = 11;
        public static final int ORIYA = 12;
        public static final int BENGALI = 13;
        public static final int TAMIL = 14;
        public static final int TELUGU = 15;
        public static final int KANNADA = 16;
        public static final int MALAYALAM = 17;
        public static final int SINHALESE = 18;
        public static final int BURMESE = 19;
        public static final int KHMER = 20;
        public static final int THAI = 21;
        public static final int LAOTIAN = 22;
        public static final int GEORGIAN = 23;
        public static final int ARMENIAN = 24;
        public static final int CHINESE_SIMPLIFIED = 25;
        public static final int TIBETAN = 26;
        public static final int MONGOLIAN = 27;
        public static final int GEEZ = 28;
        public static final int SLAVIC = 29;
        public static final int VIETNAMESE = 30;
        public static final int SINDHI = 31;
        public static final int UNINTERPRETED = 32;
    }

    public static final class MS_EncodingID {
        public static final int SYMBOL = 0;
        public static final int UNICODE_BMP = 1;
        public static final int SHIFTJIS = 2;
        public static final int PRC = 3;
        public static final int BIG5 = 4;
        public static final int WANSUNG = 5;
        public static final int JOHAB = 6;
        public static final int UNICODE_FULL = 10;
    }

    public static final class UnicodeEncodingID {
        public static final int ID_1_0 = 0;
        public static final int ID_1_1 = 1;
        public static final int ID_10646_1993 = 2;
        public static final int ID_2_0_BMP = 3;
        public static final int ID_2_0_FULL = 4;
    }

    public static final class PlatformID {
        public static final int UNICODE = 0;
        public static final int MACINTOSH = 1;
        public static final int ISO = 2;
        public static final int MICROSOFT = 3;
        public static final int CUSTOM = 4;
    }
}

