/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CFFFont;
import com.adobe.fontengine.font.cff.CIDComponentFont;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Charset;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.Encoding;
import com.adobe.fontengine.font.cff.FdSelect;
import com.adobe.fontengine.font.cff.Header;
import com.adobe.fontengine.font.cff.Index;
import com.adobe.fontengine.font.cff.NameIndex;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.cff.Type2ConsumerDefaultImpl;
import com.adobe.fontengine.font.cff.Type2OutlineParser;
import com.adobe.fontengine.font.cff.Type2Parser;
import com.adobe.fontengine.font.postscript.GlyphNamesAccessor;
import com.adobe.fontengine.font.postscript.NameHeuristics;
import com.adobe.fontengine.font.postscript.PostscriptTokenParser;
import com.adobe.fontengine.font.postscript.UnicodeCmap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public final class NameKeyedFont
extends CFFFont {
    protected final Dict privateDict;
    protected final Charset charset;
    protected final Encoding encoding;
    protected final CharStrings charStrings;
    protected final CharStrings localSubrs;
    private final XDCFontDescription xdcDescription;
    UnicodeCmap cmap = null;
    Object cmapMutex = new Object();
    static final Dict.Key[] topDictKeysForSubset = new Dict.Key[]{Dict.Key.Notice, Dict.Key.FullName, Dict.Key.FamilyName, Dict.Key.FontName, Dict.Key.BaseFontName, Dict.Key.BaseFontBlend, Dict.Key.Weight, Dict.Key.FontBBox, Dict.Key.Copyright, Dict.Key.isFixedPitch, Dict.Key.ItalicAngle, Dict.Key.UnderlinePosition, Dict.Key.UnderlineThickness, Dict.Key.PaintType, Dict.Key.CharstringType, Dict.Key.StrokeWidth, Dict.Key.UniqueID, Dict.Key.XUID, Dict.Key.UIDBase, Dict.Key.FontMatrix};
    static final Dict.Key[] privateDictKeysForSubset = new Dict.Key[]{Dict.Key.BlueValues, Dict.Key.OtherBlues, Dict.Key.FamilyBlues, Dict.Key.FamilyOtherBlues, Dict.Key.StdHW, Dict.Key.StdVW, Dict.Key.defaultWidthX, Dict.Key.nominalWidthX, Dict.Key.BlueScale, Dict.Key.BlueShift, Dict.Key.BlueFuzz, Dict.Key.StemSnapH, Dict.Key.StemSnapV, Dict.Key.ForceBold, Dict.Key.ForceBoldThreshold, Dict.Key.LanguageGroup, Dict.Key.ExpansionFactor, Dict.Key.initialRandomSeed};

    public NameKeyedFont(StringIndex stringIndex, CharStrings charStrings, String string, Dict dict, CFFByteArray cFFByteArray, byte[] byArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(stringIndex, charStrings, dict, string, byArray);
        Dict.OffsetValue offsetValue;
        this.xdcDescription = new NameKeyedFontXDCFontDescription();
        Dict.OffsetValue offsetValue2 = dict.get(Dict.Key.CharStrings, false);
        if (offsetValue2 == null) {
            throw new InvalidFontException("missing TopDICT/CharStrings");
        }
        this.charStrings = new CharStrings(cFFByteArray, offsetValue2.offset);
        int n = this.charStrings.getCount();
        Object object = dict.get(Dict.Key.charset, true);
        this.charset = new Charset(cFFByteArray, ((Dict.OffsetValue)object).offset, n);
        Object object2 = dict.get(Dict.Key.Encoding, true);
        this.encoding = new Encoding(cFFByteArray, ((Dict.OffsetValue)object2).offset);
        object2 = null;
        object = null;
        Dict.OffsetSizeValue offsetSizeValue = dict.get(Dict.Key.Private, false);
        if (offsetSizeValue != null && (offsetValue = ((Dict)(object2 = new Dict(cFFByteArray, offsetSizeValue.offset, offsetSizeValue.size, stringIndex))).get(Dict.Key.Subrs, false)) != null) {
            object = new CharStrings(cFFByteArray, offsetSizeValue.offset + offsetValue.offset);
        }
        this.privateDict = object2;
        this.localSubrs = object;
    }

    public int getNumGlyphs() {
        return this.charStrings.getCount();
    }

    public int glyphName2gid(String string) throws InvalidFontException, UnsupportedFontException {
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            if (!string.equals(this.stringIndex.getString(this.charset.gid2sid(i)))) continue;
            return i;
        }
        return 0;
    }

    public int charCode2gid(int n) throws InvalidFontException, UnsupportedFontException {
        return this.encoding.charCode2gid(n, this.charset);
    }

    public String getGlyphName(int n) throws InvalidFontException, UnsupportedFontException {
        return this.stringIndex.getString(this.charset.gid2sid(n));
    }

    public ROS getROS() {
        return null;
    }

    public int getGlyphCid(int n) {
        return -1;
    }

    public void getGlyphOutline(int n, OutlineConsumer outlineConsumer) throws InvalidFontException, UnsupportedFontException {
        this.getOutline(n, new Type2OutlineParser(false), outlineConsumer);
    }

    public void getOutline(int n, Type2OutlineParser type2OutlineParser, OutlineConsumer outlineConsumer) throws InvalidFontException, UnsupportedFontException {
        type2OutlineParser.parse(this.charStrings, n, this.localSubrs, this.globalSubrs, outlineConsumer, this.getFontMatrix(), this);
    }

    public double getStemVForGlyph(int n) {
        Dict.NumbersValue numbersValue = this.privateDict.get(Dict.NumbersKey.StdVW, false);
        if (numbersValue != null) {
            return numbersValue.getFirstValueAsDouble();
        }
        numbersValue = this.privateDict.get(Dict.NumbersKey.StemSnapV, false);
        if (numbersValue != null) {
            return numbersValue.getFirstValueAsDouble();
        }
        return 0.0;
    }

    public double getHorizontalAdvance(int n) throws InvalidFontException, UnsupportedFontException {
        Type2Parser type2Parser = new Type2Parser();
        WidthConsumer widthConsumer = new WidthConsumer();
        type2Parser.parse(this.charStrings, n, this.localSubrs, this.globalSubrs, widthConsumer, this);
        if (widthConsumer.widthSeen) {
            Dict.NumbersValue numbersValue = this.privateDict.get(Dict.Key.nominalWidthX, true);
            return numbersValue.getFirstValueAsDouble() + widthConsumer.width;
        }
        Dict.NumbersValue numbersValue = this.privateDict.get(Dict.Key.defaultWidthX, true);
        return numbersValue.getFirstValueAsDouble();
    }

    public Matrix getFontMatrix() {
        return new Matrix(this.topDict.get(Dict.Key.FontMatrix, true).getValuesAsDouble());
    }

    private Matrix getFontToMetricsMatrix() throws InvalidFontException, UnsupportedFontException {
        Matrix matrix = this.getFontMatrix();
        double d = this.getUnitsPerEmX();
        double d2 = this.getUnitsPerEmY();
        return new Matrix(d * matrix.a, d2 * matrix.b, d * matrix.c, d2 * matrix.d, d * matrix.tx, d2 * matrix.ty);
    }

    double getItalicAngle() {
        Dict.NumbersValue numbersValue = this.topDict.get(Dict.NumbersKey.ItalicAngle, false);
        if (numbersValue != null) {
            return numbersValue.getFirstValueAsDouble();
        }
        return 0.0;
    }

    Rect getRawFontBBox() {
        Dict.NumbersValue numbersValue = this.topDict.get(Dict.NumbersKey.FontBBox, false);
        if (numbersValue != null && numbersValue.values.length == 4) {
            return new Rect(numbersValue.getValuesAsDouble());
        }
        return null;
    }

    public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
        Rect rect = this.getRawFontBBox();
        if (rect == null) {
            return null;
        }
        return rect.applyMatrix(this.getFontToMetricsMatrix());
    }

    public Rect getCoolTypeRawFontBBox() throws InvalidFontException, UnsupportedFontException {
        return this.getFontBBox();
    }

    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException {
        return this.getCoolTypeLineMetricsFromFontBbox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getFirstSupportedChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getLastSupportedChar();
        }
    }

    boolean isDingbat() {
        Dict.StringValue stringValue = this.topDict.get(Dict.StringKey.FullName, true);
        return NameHeuristics.fullNameIndicatesDingbats(stringValue != null ? stringValue.value : null);
    }

    private void initCmap() throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            this.cmap = UnicodeCmap.computeCmapFromGlyphNames(this.getNumGlyphs(), this.isDingbat(), new GlyphNamesAccessor(){

                public String getAGlyphName(int n) throws UnsupportedFontException, InvalidFontException {
                    return NameKeyedFont.this.getGlyphName(n);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGlyphForChar(int n) throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getGlyphForChar(n);
        }
    }

    int[] getXUID() {
        Dict.NumbersValue numbersValue = this.topDict.get(Dict.Key.XUID, true);
        return numbersValue == null ? null : numbersValue.getValuesAsInt();
    }

    String getNotice() {
        Dict.StringValue stringValue = this.topDict.get(Dict.Key.Notice, true);
        return stringValue == null ? null : stringValue.value;
    }

    String getCopyright() {
        Dict.StringValue stringValue = this.topDict.get(Dict.Key.Copyright, true);
        return stringValue == null ? null : stringValue.value;
    }

    String getFullName() {
        Dict.StringValue stringValue = this.topDict.get(Dict.Key.FullName, true);
        return stringValue == null ? null : stringValue.value;
    }

    Integer getFSType() {
        return this.topDict.getFSType();
    }

    OrigFontType getOrigFontType() {
        return this.topDict.getOrigFontType();
    }

    double getDefaultWidthForFD(int n) {
        return this.privateDict.get(Dict.Key.defaultWidthX, true).getFirstValueAsDouble();
    }

    double getNominalWidthForFD(int n) {
        return this.privateDict.get(Dict.Key.nominalWidthX, true).getFirstValueAsDouble();
    }

    int getFDForGlyph(int n) throws InvalidFontException {
        return 0;
    }

    CharStrings getLocalSubrsForFD(int n) {
        return this.localSubrs;
    }

    int getNumFDs() {
        return 1;
    }

    CharStrings getCharStrings() {
        return this.charStrings;
    }

    public Permission getEmbeddingPermission(boolean bl) {
        return this.getEmbeddingPermissionGivenFT(bl, OrigFontType.kTYPE1);
    }

    CIDKeyedFont toCID(Subset subset) throws InvalidFontException, UnsupportedFontException {
        Object object;
        Dict.NumbersValue numbersValue;
        LinkedHashMap<Dict.Key, Dict.Value> linkedHashMap = new LinkedHashMap<Dict.Key, Dict.Value>(20, 1.0f);
        linkedHashMap.put(Dict.Key.ROS, new Dict.ROSValue("Adobe", "Identity", 0));
        linkedHashMap.put(Dict.Key.CIDCount, new Dict.IntegerValue(subset.getNumGlyphs()));
        Dict.StringValue stringValue = this.topDict.get(Dict.Key.Notice, false);
        if (stringValue != null) {
            linkedHashMap.put(Dict.Key.Notice, stringValue);
        }
        if ((stringValue = this.topDict.get(Dict.Key.FullName, false)) != null) {
            linkedHashMap.put(Dict.Key.FullName, stringValue);
        }
        linkedHashMap.put(Dict.Key.FontName, new Dict.StringValue(this.getName()));
        stringValue = this.topDict.get(Dict.Key.FamilyName, false);
        if (stringValue != null) {
            linkedHashMap.put(Dict.Key.FamilyName, stringValue);
        }
        if ((stringValue = this.topDict.get(Dict.Key.Weight, false)) != null) {
            linkedHashMap.put(Dict.Key.Weight, stringValue);
        }
        if ((numbersValue = this.topDict.get(Dict.Key.FontBBox, false)) != null) {
            linkedHashMap.put(Dict.Key.FontBBox, numbersValue);
        }
        if ((stringValue = this.topDict.get(Dict.Key.Copyright, false)) != null) {
            linkedHashMap.put(Dict.Key.Copyright, stringValue);
        }
        if ((numbersValue = this.topDict.get(Dict.Key.isFixedPitch, false)) != null) {
            linkedHashMap.put(Dict.Key.isFixedPitch, numbersValue);
        }
        if ((numbersValue = this.topDict.get(Dict.Key.ItalicAngle, false)) != null) {
            linkedHashMap.put(Dict.Key.ItalicAngle, numbersValue);
        }
        if ((numbersValue = this.topDict.get(Dict.Key.UnderlinePosition, false)) != null) {
            linkedHashMap.put(Dict.Key.UnderlinePosition, numbersValue);
        }
        if ((numbersValue = this.topDict.get(Dict.Key.UnderlineThickness, false)) != null) {
            linkedHashMap.put(Dict.Key.UnderlineThickness, numbersValue);
        }
        if ((numbersValue = this.topDict.get(Dict.Key.PaintType, false)) != null) {
            linkedHashMap.put(Dict.Key.PaintType, numbersValue);
        }
        if ((numbersValue = this.topDict.get(Dict.Key.CharstringType, false)) != null) {
            linkedHashMap.put(Dict.Key.CharstringType, numbersValue);
        }
        if ((numbersValue = this.topDict.get(Dict.Key.StrokeWidth, false)) != null) {
            linkedHashMap.put(Dict.Key.StrokeWidth, numbersValue);
        }
        if ((stringValue = this.topDict.get(Dict.Key.PostScript, false)) != null) {
            object = PostscriptTokenParser.getOrigFontType(stringValue.value);
            if (object != null) {
                linkedHashMap.put(Dict.Key.PostScript, stringValue);
            } else {
                linkedHashMap.put(Dict.Key.PostScript, new Dict.StringValue("/OrigFontType /Type1 def " + stringValue.value));
            }
        } else {
            linkedHashMap.put(Dict.Key.PostScript, new Dict.StringValue("/OrigFontType /Type1 def"));
        }
        numbersValue = this.topDict.get(Dict.Key.CIDFontType, false);
        if (numbersValue != null) {
            linkedHashMap.put(Dict.Key.CIDFontType, numbersValue);
        }
        if ((numbersValue = this.topDict.get(Dict.Key.UIDBase, false)) != null) {
            linkedHashMap.put(Dict.Key.UIDBase, numbersValue);
        }
        object = new Dict(linkedHashMap);
        linkedHashMap = new LinkedHashMap();
        numbersValue = this.topDict.get(Dict.Key.FontMatrix, false);
        if (numbersValue != null) {
            linkedHashMap.put(Dict.Key.FontMatrix, numbersValue);
        }
        Dict dict = new Dict(linkedHashMap);
        CIDComponentFont[] cIDComponentFontArray = new CIDComponentFont[]{new CIDComponentFont(dict, this.privateDict, null)};
        return new CIDKeyedFont(null, null, this.name, (Dict)object, this.createSubsetCharstringIndex(subset), Charset.identityCharset(subset.getNumGlyphs()), cIDComponentFontArray, FdSelect.singleFont(subset.getNumGlyphs()));
    }

    public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl, Integer n) throws InvalidFontException, UnsupportedFontException, IOException {
        this.toCID(subset).subsetAndStream(new SubsetDefaultImpl(subset.getNumGlyphs(), false), outputStream, false, n);
    }

    private void setPSString(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, Integer n, List list) {
        OrigFontType origFontType;
        String string = null;
        if (n == null) {
            n = this.topDict.getFSType();
        }
        if (n != null) {
            string = "/FSType " + n.toString() + " def ";
        }
        if ((origFontType = this.topDict.getOrigFontType()) != null) {
            string = string != null ? string + " /OrigFontType /" + origFontType.toString() + " def" : "/OrigFontType /" + origFontType.toString() + " def";
        }
        if (string != null) {
            if (list.indexOf(string) == -1) {
                list.add(string);
            }
            Dict.streamKeyVal(cFFByteArrayBuilder, Dict.Key.PostScript, string, list);
        }
    }

    public void subsetAndStream(SubsetSimpleType1 subsetSimpleType1, OutputStream outputStream, Integer n) throws InvalidFontException, UnsupportedFontException, IOException {
        int n2;
        Object object;
        List list = StringIndex.collectPredefinedStrings();
        String[] stringArray = subsetSimpleType1.getGlyphNames();
        int[] nArray = new int[stringArray.length];
        Subset subset = this.createSubset();
        for (int i = 1; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (object == null) continue;
            int n3 = this.glyphName2gid((String)object);
            if (n3 <= 0) {
                throw new InvalidFontException("Font does not contain required codepoint");
            }
            subset.getSubsetGid(n3);
            n2 = list.indexOf(object);
            if (n2 < 0) {
                list.add(object);
                n2 = list.size() - 1;
            }
            nArray[i] = n2;
        }
        this.topDict.collectStrings(list);
        Dict.StringValue stringValue = this.topDict.get(Dict.StringKey.PostScript, false);
        if (stringValue != null) {
            list.remove(list.indexOf(stringValue.value));
        }
        object = CFFByteArray.getCFFByteArrayBuilderInstance();
        Header.toBinary((CFFByteArray.CFFByteArrayBuilder)object);
        NameIndex.toBinary((CFFByteArray.CFFByteArrayBuilder)object, this.name);
        Index.Cursor cursor = Index.startIndex((CFFByteArray.CFFByteArrayBuilder)object, 1);
        this.topDict.stream((CFFByteArray.CFFByteArrayBuilder)object, list, topDictKeysForSubset);
        this.setPSString((CFFByteArray.CFFByteArrayBuilder)object, n, list);
        n2 = Dict.Key.charset.streamDummyValue((CFFByteArray.CFFByteArrayBuilder)object);
        int n4 = Dict.Key.CharStrings.streamDummyValue((CFFByteArray.CFFByteArrayBuilder)object);
        int n5 = Dict.Key.Private.streamDummyValue((CFFByteArray.CFFByteArrayBuilder)object);
        cursor = Index.elementEntered((CFFByteArray.CFFByteArrayBuilder)object, cursor);
        StringIndex.toBinary((CFFByteArray.CFFByteArrayBuilder)object, list);
        ((CFFByteArray.CFFByteArrayBuilder)object).addCard16(0);
        Dict.Key.charset.fixOffset((CFFByteArray.CFFByteArrayBuilder)object, n2, ((FontByteArray.FontByteArrayBuilder)object).getSize());
        Charset.charSetFromSubset(this.charset, subset).stream((CFFByteArray.CFFByteArrayBuilder)object);
        Dict.Key.CharStrings.fixOffset((CFFByteArray.CFFByteArrayBuilder)object, n4, ((FontByteArray.FontByteArrayBuilder)object).getSize());
        CharStrings charStrings = this.createSubsetCharstringIndex(subset);
        charStrings.stream((CFFByteArray.CFFByteArrayBuilder)object);
        int n6 = ((FontByteArray.FontByteArrayBuilder)object).getSize();
        Dict.Key.Private.fixOffset((CFFByteArray.CFFByteArrayBuilder)object, n5, n6);
        this.privateDict.stream((CFFByteArray.CFFByteArrayBuilder)object, list, privateDictKeysForSubset);
        Dict.Key.Private.fixSize((CFFByteArray.CFFByteArrayBuilder)object, n5, ((FontByteArray.FontByteArrayBuilder)object).getSize() - n6);
        CFFByteArray cFFByteArray = ((CFFByteArray.CFFByteArrayBuilder)object).toCFFByteArray();
        cFFByteArray.write(outputStream);
    }

    public PDFFontDescription getPDFFontDescription(Font font) throws UnsupportedFontException, InvalidFontException {
        return this.xdcDescription;
    }

    public XDCFontDescription getXDCFontDescription(Font font) throws UnsupportedFontException, InvalidFontException {
        return this.xdcDescription;
    }

    private class NameKeyedFontXDCFontDescription
    extends CFFFont.CFFFontXDCFontDescription {
        private NameKeyedFontXDCFontDescription() {
        }

        public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl) throws InvalidFontException, UnsupportedFontException, IOException {
            NameKeyedFont.this.subsetAndStream(subset, outputStream, bl);
        }

        public void subsetAndStream(SubsetSimpleType1 subsetSimpleType1, OutputStream outputStream) throws InvalidFontException, UnsupportedFontException, IOException {
            NameKeyedFont.this.subsetAndStream(subsetSimpleType1, outputStream, NameKeyedFont.this.getFSType());
        }

        public void subsetAndStream(SubsetSimpleTrueType subsetSimpleTrueType, OutputStream outputStream) throws UnsupportedFontException {
            throw new UnsupportedFontException("Not a TrueType font");
        }

        public CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException {
            HashSet<CodePage> hashSet = new HashSet<CodePage>();
            if (NameKeyedFont.this.glyphName2gid("ecircumflex") > 0) {
                hashSet.add(CodePage.ROMAN1);
            }
            if (NameKeyedFont.this.glyphName2gid("Ccaron") > 0 || NameKeyedFont.this.glyphName2gid("ncaron") > 0) {
                hashSet.add(CodePage.ROMAN2);
            }
            if (NameKeyedFont.this.glyphName2gid("akatakana") > 0) {
                hashSet.add(CodePage.JAPANESE);
            }
            CodePage[] codePageArray = new CodePage[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                codePageArray[n++] = (CodePage)iterator.next();
            }
            return codePageArray;
        }
    }

    static class WidthConsumer
    extends Type2ConsumerDefaultImpl {
        public double width;
        public boolean widthSeen = false;

        WidthConsumer() {
        }

        public boolean width(double d) {
            this.widthSeen = true;
            this.width = d;
            return false;
        }
    }
}

