/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import java.math.BigInteger;
import llvm.APInt;
import llvm.AnalysisUsage;
import llvm.CmpInst;
import llvm.Constant;
import llvm.ConstantInt;
import llvm.Function;
import llvm.FunctionPass;
import llvm.LLVMContext;
import llvm.Module;
import llvm.SCEV;
import llvm.SWIGTYPE_p_llvm__ConstantRange;
import llvm.SWIGTYPE_p_llvm__Loop;
import llvm.SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t;
import llvm.StructType;
import llvm.Type;
import llvm.Value;
import llvm.llvmJNI;
import llvm.raw_ostream;

public class ScalarEvolution
extends FunctionPass {
    private long swigCPtr;

    protected ScalarEvolution(long l2, boolean bl2) {
        super(llvmJNI.SWIGScalarEvolutionUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(ScalarEvolution scalarEvolution) {
        return scalarEvolution == null ? 0L : scalarEvolution.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_ScalarEvolution(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static void setID(char c2) {
        llvmJNI.ScalarEvolution_ID_set(c2);
    }

    public static char getID() {
        return llvmJNI.ScalarEvolution_ID_get();
    }

    public ScalarEvolution() {
        this(llvmJNI.new_ScalarEvolution(), true);
    }

    public LLVMContext getContext() {
        return new LLVMContext(llvmJNI.ScalarEvolution_getContext(this.swigCPtr, this), false);
    }

    public boolean isSCEVable(Type type) {
        return llvmJNI.ScalarEvolution_isSCEVable(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public BigInteger getTypeSizeInBits(Type type) {
        return llvmJNI.ScalarEvolution_getTypeSizeInBits(this.swigCPtr, this, Type.getCPtr(type), type);
    }

    public Type getEffectiveSCEVType(Type type) {
        long l2 = llvmJNI.ScalarEvolution_getEffectiveSCEVType(this.swigCPtr, this, Type.getCPtr(type), type);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public SCEV getSCEV(Value value) {
        long l2 = llvmJNI.ScalarEvolution_getSCEV(this.swigCPtr, this, Value.getCPtr(value), value);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getConstant(ConstantInt constantInt) {
        long l2 = llvmJNI.ScalarEvolution_getConstant__SWIG_0(this.swigCPtr, this, ConstantInt.getCPtr(constantInt), constantInt);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getConstant(APInt aPInt) {
        long l2 = llvmJNI.ScalarEvolution_getConstant__SWIG_1(this.swigCPtr, this, APInt.getCPtr(aPInt), aPInt);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getConstant(Type type, BigInteger bigInteger, boolean bl2) {
        long l2 = llvmJNI.ScalarEvolution_getConstant__SWIG_2(this.swigCPtr, this, Type.getCPtr(type), type, bigInteger, bl2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getConstant(Type type, BigInteger bigInteger) {
        long l2 = llvmJNI.ScalarEvolution_getConstant__SWIG_3(this.swigCPtr, this, Type.getCPtr(type), type, bigInteger);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getTruncateExpr(SCEV sCEV, Type type) {
        long l2 = llvmJNI.ScalarEvolution_getTruncateExpr(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getZeroExtendExpr(SCEV sCEV, Type type) {
        long l2 = llvmJNI.ScalarEvolution_getZeroExtendExpr(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getSignExtendExpr(SCEV sCEV, Type type) {
        long l2 = llvmJNI.ScalarEvolution_getSignExtendExpr(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAnyExtendExpr(SCEV sCEV, Type type) {
        long l2 = llvmJNI.ScalarEvolution_getAnyExtendExpr(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t, boolean bl2, boolean bl3) {
        long l2 = llvmJNI.ScalarEvolution_getAddExpr__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t), bl2, bl3);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t, boolean bl2) {
        long l2 = llvmJNI.ScalarEvolution_getAddExpr__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t), bl2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t) {
        long l2 = llvmJNI.ScalarEvolution_getAddExpr__SWIG_2(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t));
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddExpr(SCEV sCEV, SCEV sCEV2, boolean bl2, boolean bl3) {
        long l2 = llvmJNI.ScalarEvolution_getAddExpr__SWIG_3(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, bl2, bl3);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddExpr(SCEV sCEV, SCEV sCEV2, boolean bl2) {
        long l2 = llvmJNI.ScalarEvolution_getAddExpr__SWIG_4(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, bl2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddExpr(SCEV sCEV, SCEV sCEV2) {
        long l2 = llvmJNI.ScalarEvolution_getAddExpr__SWIG_5(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddExpr(SCEV sCEV, SCEV sCEV2, SCEV sCEV3, boolean bl2, boolean bl3) {
        long l2 = llvmJNI.ScalarEvolution_getAddExpr__SWIG_6(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, SCEV.getCPtr(sCEV3), sCEV3, bl2, bl3);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddExpr(SCEV sCEV, SCEV sCEV2, SCEV sCEV3, boolean bl2) {
        long l2 = llvmJNI.ScalarEvolution_getAddExpr__SWIG_7(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, SCEV.getCPtr(sCEV3), sCEV3, bl2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddExpr(SCEV sCEV, SCEV sCEV2, SCEV sCEV3) {
        long l2 = llvmJNI.ScalarEvolution_getAddExpr__SWIG_8(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, SCEV.getCPtr(sCEV3), sCEV3);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getMulExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t, boolean bl2, boolean bl3) {
        long l2 = llvmJNI.ScalarEvolution_getMulExpr__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t), bl2, bl3);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getMulExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t, boolean bl2) {
        long l2 = llvmJNI.ScalarEvolution_getMulExpr__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t), bl2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getMulExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t) {
        long l2 = llvmJNI.ScalarEvolution_getMulExpr__SWIG_2(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t));
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getMulExpr(SCEV sCEV, SCEV sCEV2, boolean bl2, boolean bl3) {
        long l2 = llvmJNI.ScalarEvolution_getMulExpr__SWIG_3(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, bl2, bl3);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getMulExpr(SCEV sCEV, SCEV sCEV2, boolean bl2) {
        long l2 = llvmJNI.ScalarEvolution_getMulExpr__SWIG_4(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, bl2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getMulExpr(SCEV sCEV, SCEV sCEV2) {
        long l2 = llvmJNI.ScalarEvolution_getMulExpr__SWIG_5(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getUDivExpr(SCEV sCEV, SCEV sCEV2) {
        long l2 = llvmJNI.ScalarEvolution_getUDivExpr(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddRecExpr(SCEV sCEV, SCEV sCEV2, SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop, boolean bl2, boolean bl3) {
        long l2 = llvmJNI.ScalarEvolution_getAddRecExpr__SWIG_0(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop), bl2, bl3);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddRecExpr(SCEV sCEV, SCEV sCEV2, SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop, boolean bl2) {
        long l2 = llvmJNI.ScalarEvolution_getAddRecExpr__SWIG_1(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop), bl2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddRecExpr(SCEV sCEV, SCEV sCEV2, SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop) {
        long l2 = llvmJNI.ScalarEvolution_getAddRecExpr__SWIG_2(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop));
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddRecExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t, SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop, boolean bl2, boolean bl3) {
        long l2 = llvmJNI.ScalarEvolution_getAddRecExpr__SWIG_3(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t), SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop), bl2, bl3);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddRecExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t, SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop, boolean bl2) {
        long l2 = llvmJNI.ScalarEvolution_getAddRecExpr__SWIG_4(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t), SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop), bl2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAddRecExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t, SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop) {
        long l2 = llvmJNI.ScalarEvolution_getAddRecExpr__SWIG_5(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t), SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop));
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getSMaxExpr(SCEV sCEV, SCEV sCEV2) {
        long l2 = llvmJNI.ScalarEvolution_getSMaxExpr__SWIG_0(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getSMaxExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t) {
        long l2 = llvmJNI.ScalarEvolution_getSMaxExpr__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t));
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getUMaxExpr(SCEV sCEV, SCEV sCEV2) {
        long l2 = llvmJNI.ScalarEvolution_getUMaxExpr__SWIG_0(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getUMaxExpr(SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t) {
        long l2 = llvmJNI.ScalarEvolution_getUMaxExpr__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t.getCPtr(sWIGTYPE_p_llvm__SmallVectorImplT_llvm__SCEV_const_p_t));
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getSMinExpr(SCEV sCEV, SCEV sCEV2) {
        long l2 = llvmJNI.ScalarEvolution_getSMinExpr(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getUMinExpr(SCEV sCEV, SCEV sCEV2) {
        long l2 = llvmJNI.ScalarEvolution_getUMinExpr(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getUnknown(Value value) {
        long l2 = llvmJNI.ScalarEvolution_getUnknown(this.swigCPtr, this, Value.getCPtr(value), value);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getCouldNotCompute() {
        long l2 = llvmJNI.ScalarEvolution_getCouldNotCompute(this.swigCPtr, this);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getSizeOfExpr(Type type) {
        long l2 = llvmJNI.ScalarEvolution_getSizeOfExpr(this.swigCPtr, this, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getAlignOfExpr(Type type) {
        long l2 = llvmJNI.ScalarEvolution_getAlignOfExpr(this.swigCPtr, this, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getOffsetOfExpr(StructType structType, long l2) {
        long l3 = llvmJNI.ScalarEvolution_getOffsetOfExpr__SWIG_0(this.swigCPtr, this, StructType.getCPtr(structType), structType, l2);
        return l3 == 0L ? null : new SCEV(l3, false);
    }

    public SCEV getOffsetOfExpr(Type type, Constant constant) {
        long l2 = llvmJNI.ScalarEvolution_getOffsetOfExpr__SWIG_1(this.swigCPtr, this, Type.getCPtr(type), type, Constant.getCPtr(constant), constant);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getNegativeSCEV(SCEV sCEV) {
        long l2 = llvmJNI.ScalarEvolution_getNegativeSCEV(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getNotSCEV(SCEV sCEV) {
        long l2 = llvmJNI.ScalarEvolution_getNotSCEV(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getMinusSCEV(SCEV sCEV, SCEV sCEV2) {
        long l2 = llvmJNI.ScalarEvolution_getMinusSCEV(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getTruncateOrZeroExtend(SCEV sCEV, Type type) {
        long l2 = llvmJNI.ScalarEvolution_getTruncateOrZeroExtend(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getTruncateOrSignExtend(SCEV sCEV, Type type) {
        long l2 = llvmJNI.ScalarEvolution_getTruncateOrSignExtend(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getNoopOrZeroExtend(SCEV sCEV, Type type) {
        long l2 = llvmJNI.ScalarEvolution_getNoopOrZeroExtend(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getNoopOrSignExtend(SCEV sCEV, Type type) {
        long l2 = llvmJNI.ScalarEvolution_getNoopOrSignExtend(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getNoopOrAnyExtend(SCEV sCEV, Type type) {
        long l2 = llvmJNI.ScalarEvolution_getNoopOrAnyExtend(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getTruncateOrNoop(SCEV sCEV, Type type) {
        long l2 = llvmJNI.ScalarEvolution_getTruncateOrNoop(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, Type.getCPtr(type), type);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getIntegerSCEV(long l2, Type type) {
        long l3 = llvmJNI.ScalarEvolution_getIntegerSCEV(this.swigCPtr, this, l2, Type.getCPtr(type), type);
        return l3 == 0L ? null : new SCEV(l3, false);
    }

    public SCEV getUMaxFromMismatchedTypes(SCEV sCEV, SCEV sCEV2) {
        long l2 = llvmJNI.ScalarEvolution_getUMaxFromMismatchedTypes(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getUMinFromMismatchedTypes(SCEV sCEV, SCEV sCEV2) {
        long l2 = llvmJNI.ScalarEvolution_getUMinFromMismatchedTypes(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getSCEVAtScope(SCEV sCEV, SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop) {
        long l2 = llvmJNI.ScalarEvolution_getSCEVAtScope__SWIG_0(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop));
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getSCEVAtScope(Value value, SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop) {
        long l2 = llvmJNI.ScalarEvolution_getSCEVAtScope__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), value, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop));
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public boolean isLoopGuardedByCond(SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop, CmpInst.Predicate predicate, SCEV sCEV, SCEV sCEV2) {
        return llvmJNI.ScalarEvolution_isLoopGuardedByCond(this.swigCPtr, this, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop), predicate.swigValue(), SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
    }

    public boolean isLoopBackedgeGuardedByCond(SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop, CmpInst.Predicate predicate, SCEV sCEV, SCEV sCEV2) {
        return llvmJNI.ScalarEvolution_isLoopBackedgeGuardedByCond(this.swigCPtr, this, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop), predicate.swigValue(), SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
    }

    public SCEV getBackedgeTakenCount(SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop) {
        long l2 = llvmJNI.ScalarEvolution_getBackedgeTakenCount(this.swigCPtr, this, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop));
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public SCEV getMaxBackedgeTakenCount(SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop) {
        long l2 = llvmJNI.ScalarEvolution_getMaxBackedgeTakenCount(this.swigCPtr, this, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop));
        return l2 == 0L ? null : new SCEV(l2, false);
    }

    public boolean hasLoopInvariantBackedgeTakenCount(SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop) {
        return llvmJNI.ScalarEvolution_hasLoopInvariantBackedgeTakenCount(this.swigCPtr, this, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop));
    }

    public void forgetLoop(SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop) {
        llvmJNI.ScalarEvolution_forgetLoop(this.swigCPtr, this, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop));
    }

    public void forgetValue(Value value) {
        llvmJNI.ScalarEvolution_forgetValue(this.swigCPtr, this, Value.getCPtr(value), value);
    }

    public long GetMinTrailingZeros(SCEV sCEV) {
        return llvmJNI.ScalarEvolution_GetMinTrailingZeros(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV);
    }

    public SWIGTYPE_p_llvm__ConstantRange getUnsignedRange(SCEV sCEV) {
        return new SWIGTYPE_p_llvm__ConstantRange(llvmJNI.ScalarEvolution_getUnsignedRange(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV), true);
    }

    public SWIGTYPE_p_llvm__ConstantRange getSignedRange(SCEV sCEV) {
        return new SWIGTYPE_p_llvm__ConstantRange(llvmJNI.ScalarEvolution_getSignedRange(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV), true);
    }

    public boolean isKnownNegative(SCEV sCEV) {
        return llvmJNI.ScalarEvolution_isKnownNegative(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV);
    }

    public boolean isKnownPositive(SCEV sCEV) {
        return llvmJNI.ScalarEvolution_isKnownPositive(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV);
    }

    public boolean isKnownNonNegative(SCEV sCEV) {
        return llvmJNI.ScalarEvolution_isKnownNonNegative(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV);
    }

    public boolean isKnownNonPositive(SCEV sCEV) {
        return llvmJNI.ScalarEvolution_isKnownNonPositive(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV);
    }

    public boolean isKnownNonZero(SCEV sCEV) {
        return llvmJNI.ScalarEvolution_isKnownNonZero(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV);
    }

    public boolean isKnownPredicate(CmpInst.Predicate predicate, SCEV sCEV, SCEV sCEV2) {
        return llvmJNI.ScalarEvolution_isKnownPredicate(this.swigCPtr, this, predicate.swigValue(), SCEV.getCPtr(sCEV), sCEV, SCEV.getCPtr(sCEV2), sCEV2);
    }

    public boolean runOnFunction(Function function) {
        return llvmJNI.ScalarEvolution_runOnFunction(this.swigCPtr, this, Function.getCPtr(function), function);
    }

    public void releaseMemory() {
        llvmJNI.ScalarEvolution_releaseMemory(this.swigCPtr, this);
    }

    public void getAnalysisUsage(AnalysisUsage analysisUsage) {
        llvmJNI.ScalarEvolution_getAnalysisUsage(this.swigCPtr, this, AnalysisUsage.getCPtr(analysisUsage), analysisUsage);
    }

    public void print(raw_ostream raw_ostream2, Module module) {
        llvmJNI.ScalarEvolution_print__SWIG_0(this.swigCPtr, this, raw_ostream.getCPtr(raw_ostream2), raw_ostream2, Module.getCPtr(module), module);
    }

    public void print(raw_ostream raw_ostream2) {
        llvmJNI.ScalarEvolution_print__SWIG_1(this.swigCPtr, this, raw_ostream.getCPtr(raw_ostream2), raw_ostream2);
    }
}

