/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.AnalysisResolver;
import llvm.AnalysisUsage;
import llvm.ImmutablePass;
import llvm.Module;
import llvm.PassInfo;
import llvm.PassKind;
import llvm.PassManagerType;
import llvm.SWIGTYPE_p_intptr_t;
import llvm.SWIGTYPE_p_llvm__PMDataManager;
import llvm.SWIGTYPE_p_llvm__PMStack;
import llvm.SWIGTYPE_p_void;
import llvm.StringRef;
import llvm.llvmJNI;
import llvm.raw_ostream;

public class Pass {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected Pass(long l2, boolean bl2) {
        this.swigCMemOwn = bl2;
        this.swigCPtr = l2;
    }

    protected static long getCPtr(Pass pass) {
        return pass == null ? 0L : pass.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_Pass(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Pass(PassKind passKind, SWIGTYPE_p_intptr_t sWIGTYPE_p_intptr_t) {
        this(llvmJNI.new_Pass__SWIG_0(passKind.swigValue(), SWIGTYPE_p_intptr_t.getCPtr(sWIGTYPE_p_intptr_t)), true);
    }

    public Pass(PassKind passKind, SWIGTYPE_p_void sWIGTYPE_p_void) {
        this(llvmJNI.new_Pass__SWIG_1(passKind.swigValue(), SWIGTYPE_p_void.getCPtr(sWIGTYPE_p_void)), true);
    }

    public PassKind getPassKind() {
        return PassKind.swigToEnum(llvmJNI.Pass_getPassKind(this.swigCPtr, this));
    }

    public String getPassName() {
        return llvmJNI.Pass_getPassName(this.swigCPtr, this);
    }

    public PassInfo getPassInfo() {
        long l2 = llvmJNI.Pass_getPassInfo(this.swigCPtr, this);
        return l2 == 0L ? null : new PassInfo(l2, false);
    }

    public void print(raw_ostream raw_ostream2, Module module) {
        llvmJNI.Pass_print(this.swigCPtr, this, raw_ostream.getCPtr(raw_ostream2), raw_ostream2, Module.getCPtr(module), module);
    }

    public void dump() {
        llvmJNI.Pass_dump(this.swigCPtr, this);
    }

    public void assignPassManager(SWIGTYPE_p_llvm__PMStack sWIGTYPE_p_llvm__PMStack, PassManagerType passManagerType) {
        llvmJNI.Pass_assignPassManager__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_llvm__PMStack.getCPtr(sWIGTYPE_p_llvm__PMStack), passManagerType.swigValue());
    }

    public void assignPassManager(SWIGTYPE_p_llvm__PMStack sWIGTYPE_p_llvm__PMStack) {
        llvmJNI.Pass_assignPassManager__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_llvm__PMStack.getCPtr(sWIGTYPE_p_llvm__PMStack));
    }

    public void preparePassManager(SWIGTYPE_p_llvm__PMStack sWIGTYPE_p_llvm__PMStack) {
        llvmJNI.Pass_preparePassManager(this.swigCPtr, this, SWIGTYPE_p_llvm__PMStack.getCPtr(sWIGTYPE_p_llvm__PMStack));
    }

    public PassManagerType getPotentialPassManagerType() {
        return PassManagerType.swigToEnum(llvmJNI.Pass_getPotentialPassManagerType(this.swigCPtr, this));
    }

    public void setResolver(AnalysisResolver analysisResolver) {
        llvmJNI.Pass_setResolver(this.swigCPtr, this, AnalysisResolver.getCPtr(analysisResolver), analysisResolver);
    }

    public AnalysisResolver getResolver() {
        long l2 = llvmJNI.Pass_getResolver(this.swigCPtr, this);
        return l2 == 0L ? null : new AnalysisResolver(l2, false);
    }

    public void getAnalysisUsage(AnalysisUsage analysisUsage) {
        llvmJNI.Pass_getAnalysisUsage(this.swigCPtr, this, AnalysisUsage.getCPtr(analysisUsage), analysisUsage);
    }

    public void releaseMemory() {
        llvmJNI.Pass_releaseMemory(this.swigCPtr, this);
    }

    public SWIGTYPE_p_void getAdjustedAnalysisPointer(PassInfo passInfo) {
        long l2 = llvmJNI.Pass_getAdjustedAnalysisPointer(this.swigCPtr, this, PassInfo.getCPtr(passInfo), passInfo);
        return l2 == 0L ? null : new SWIGTYPE_p_void(l2, false);
    }

    public ImmutablePass getAsImmutablePass() {
        long l2 = llvmJNI.Pass_getAsImmutablePass(this.swigCPtr, this);
        return l2 == 0L ? null : new ImmutablePass(l2, false);
    }

    public SWIGTYPE_p_llvm__PMDataManager getAsPMDataManager() {
        long l2 = llvmJNI.Pass_getAsPMDataManager(this.swigCPtr, this);
        return l2 == 0L ? null : new SWIGTYPE_p_llvm__PMDataManager(l2, false);
    }

    public void verifyAnalysis() {
        llvmJNI.Pass_verifyAnalysis(this.swigCPtr, this);
    }

    public void dumpPassStructure(long l2) {
        llvmJNI.Pass_dumpPassStructure__SWIG_0(this.swigCPtr, this, l2);
    }

    public void dumpPassStructure() {
        llvmJNI.Pass_dumpPassStructure__SWIG_1(this.swigCPtr, this);
    }

    public static PassInfo lookupPassInfo(SWIGTYPE_p_intptr_t sWIGTYPE_p_intptr_t) {
        long l2 = llvmJNI.Pass_lookupPassInfo__SWIG_0(SWIGTYPE_p_intptr_t.getCPtr(sWIGTYPE_p_intptr_t));
        return l2 == 0L ? null : new PassInfo(l2, false);
    }

    public static PassInfo lookupPassInfo(StringRef stringRef) {
        long l2 = llvmJNI.Pass_lookupPassInfo__SWIG_1(StringRef.getCPtr(stringRef), stringRef);
        return l2 == 0L ? null : new PassInfo(l2, false);
    }

    public boolean mustPreserveAnalysisID(PassInfo passInfo) {
        return llvmJNI.Pass_mustPreserveAnalysisID(this.swigCPtr, this, PassInfo.getCPtr(passInfo), passInfo);
    }
}

