/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.Instruction;
import llvm.PointerType;
import llvm.Type;
import llvm.UnaryInstruction;
import llvm.Value;
import llvm.llvmJNI;

public class AllocaInst
extends UnaryInstruction {
    private long swigCPtr;

    protected AllocaInst(long l2, boolean bl2) {
        super(llvmJNI.SWIGAllocaInstUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(AllocaInst allocaInst) {
        return allocaInst == null ? 0L : allocaInst.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_AllocaInst(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static AllocaInst Create(Type type, Value value) {
        long l2 = llvmJNI.AllocaInst_Create(Type.getCPtr(type), type, Value.getCPtr(value), value);
        return l2 == 0L ? null : new AllocaInst(l2, false);
    }

    public boolean isArrayAllocation() {
        return llvmJNI.AllocaInst_isArrayAllocation(this.swigCPtr, this);
    }

    public Value getArraySize() {
        long l2 = llvmJNI.AllocaInst_getArraySize__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Value(l2, false);
    }

    public PointerType getType() {
        long l2 = llvmJNI.AllocaInst_getType(this.swigCPtr, this);
        return l2 == 0L ? null : new PointerType(l2, false);
    }

    public Type getAllocatedType() {
        long l2 = llvmJNI.AllocaInst_getAllocatedType(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public long getAlignment() {
        return llvmJNI.AllocaInst_getAlignment(this.swigCPtr, this);
    }

    public void setAlignment(long l2) {
        llvmJNI.AllocaInst_setAlignment(this.swigCPtr, this, l2);
    }

    public boolean isStaticAlloca() {
        return llvmJNI.AllocaInst_isStaticAlloca(this.swigCPtr, this);
    }

    public static boolean classof(AllocaInst allocaInst) {
        return llvmJNI.AllocaInst_classof__SWIG_0(AllocaInst.getCPtr(allocaInst), allocaInst);
    }

    public static boolean classof(Instruction instruction) {
        return llvmJNI.AllocaInst_classof__SWIG_1(Instruction.getCPtr(instruction), instruction);
    }

    public static boolean classof(Value value) {
        return llvmJNI.AllocaInst_classof__SWIG_2(Value.getCPtr(value), value);
    }

    public static AllocaInst dyn_cast(UnaryInstruction unaryInstruction) {
        long l2 = llvmJNI.AllocaInst_dyn_cast(UnaryInstruction.getCPtr(unaryInstruction), unaryInstruction);
        return l2 == 0L ? null : new AllocaInst(l2, false);
    }
}

