/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml;

import com.rsa.certj.CertJ;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.xml.KeyValue;
import com.rsa.certj.xml.RetrievalMethod;
import com.rsa.certj.xml.X509Data;
import com.rsa.certj.xml.XMLException;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class KeyInfo
implements Cloneable,
Serializable {
    public static final int KEYNAME_KEYINFO = 0;
    public static final int KEYVALUE_KEYINFO = 1;
    public static final int X509DATA_KEYINFO = 2;
    public static final int RETRIEVALMETHOD_KEYINFO = 3;
    public static final int PGPDATA_KEYINFO = 4;
    public static final int SPKIDATA_KEYINFO = 5;
    public static final int MGMTDATA_KEYINFO = 6;
    public static final String X509DATA_TYPE = "http://www.w3.org/2000/09/xmldsig#X509Data";
    public static final String PGPDATA_TYPE = "http://www.w3.org/2000/09/xmldsig#PGPData";
    public static final String SPKIDATA_TYPE = "http://www.w3.org/2000/09/xmldsig#SPKIData";
    public static final String MGMTDATA_TYPE = "http://www.w3.org/2000/09/xmldsig#MgmtData";
    public static final String X509CERTIFICATE_TYPE = "http://www.w3.org/2000/09/xmldsig#rawX509Certificate";
    private static Hashtable a = new Hashtable();

    protected static Hashtable getAllKeyInfos() {
        return a;
    }

    public static KeyInfo getInstance(String string) throws XMLException {
        KeyInfo keyInfo;
        String string2 = string;
        if (string == null) {
            throw new XMLException("keyInfoName is null");
        }
        if (string.endsWith("KeyValue")) {
            string2 = "KeyValue";
        } else if (string.endsWith("X509Data")) {
            string2 = "X509Data";
        } else if (string.endsWith("RetrievalMethod")) {
            string2 = "RetrievalMethod";
        }
        if (!a.containsKey(string2)) {
            throw new XMLException("Not supported keyInfo type: " + string2);
        }
        Object v2 = a.get(string2);
        try {
            keyInfo = (KeyInfo)((KeyInfo)v2).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new XMLException("Can not generate a KeyInfo object on: " + string2);
        }
        return keyInfo;
    }

    public abstract int getKeyInfoType();

    public abstract String getKeyInfoName();

    public abstract Element generateKeyInfo(Document var1, String var2, String var3) throws XMLException;

    public abstract void parseKeyInfo(Element var1, String var2) throws XMLException;

    public abstract boolean hasKey() throws XMLException;

    public abstract boolean hasCertificate() throws XMLException;

    public abstract Certificate[] getCertificates(CertJ var1) throws XMLException;

    public abstract JSAFE_PublicKey getKey() throws XMLException;

    public abstract void setKey(JSAFE_PublicKey var1) throws XMLException;

    public abstract void setCertificates(Certificate[] var1) throws XMLException;

    static {
        a.put("KeyValue", new KeyValue());
        a.put("X509Data", new X509Data());
        a.put("RetrievalMethod", new RetrievalMethod());
    }
}

