/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralNames;
import java.io.Serializable;

public class SemanticsInformation
implements Cloneable,
Serializable {
    private byte[] a = null;
    private GeneralNames b = null;
    protected static int special;
    private ASN1Template c = null;

    public SemanticsInformation(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null || n2 < 0) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n3);
            OIDContainer oIDContainer = new OIDContainer(0x1010000);
            EncodedContainer encodedContainer = new EncodedContainer(77824);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (oIDContainer.data == null && encodedContainer.data == null) {
                throw new NameException("At least one field in SemanticsInformation shall be present.");
            }
            if (oIDContainer.data != null) {
                this.a = new byte[oIDContainer.dataLen];
                System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, this.a, 0, oIDContainer.dataLen);
            }
            if (encodedContainer.data != null) {
                this.b = new GeneralNames(encodedContainer.data, encodedContainer.dataOffset, 0);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Invalid encoding of SemanticsInformation. " + aSN_Exception.getMessage());
        }
    }

    public SemanticsInformation() {
    }

    public void setName(GeneralNames generalNames) {
        this.b = generalNames;
    }

    public GeneralNames getName() {
        return this.b;
    }

    public void setID(byte[] byArray, int n2, int n3) {
        if (byArray != null && n3 != 0 && n2 >= 0 && byArray.length >= n3 + n2) {
            this.a = new byte[n3];
            System.arraycopy(byArray, n2, this.a, 0, n3);
        } else {
            this.a = null;
        }
    }

    public byte[] getID() {
        if (this.a == null) {
            return null;
        }
        byte[] byArray = new byte[this.a.length];
        System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        return byArray;
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER. " + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n2) throws NameException {
        if (this.b == null && this.a == null) {
            throw new NameException("At least one value should be present.");
        }
        special = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n4;
            block8: {
                block7: {
                    if (this.c == null) break block7;
                    if (n3 == special) break block8;
                }
                if ((n4 = this.getDERLen(n3)) == 0) {
                    throw new NameException("Cannot encode SemanticsInformation.");
                }
            }
            n4 = this.c.derEncode(byArray, n2);
            this.c = null;
            return n4;
        }
        catch (ASN_Exception aSN_Exception) {
            this.c = null;
            throw new NameException("Unable to encode SemanticsInformation." + aSN_Exception.getMessage());
        }
    }

    private int a() throws NameException {
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(special);
            OIDContainer oIDContainer = null;
            EncodedContainer encodedContainer = null;
            EndContainer endContainer = new EndContainer();
            oIDContainer = this.a != null ? new OIDContainer(0x1010000, true, 0, this.a, 0, this.a.length) : new OIDContainer(0x1010000, false, 0, null, 0, 0);
            if (this.b != null) {
                int n2 = this.b.getDERLen(0);
                byte[] byArray = new byte[n2];
                n2 = this.b.getDEREncoding(byArray, 0, 0);
                encodedContainer = new EncodedContainer(77824, true, 0, byArray, 0, byArray.length);
            } else {
                encodedContainer = new EncodedContainer(77824, true, 0, null, 0, 0);
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("cannot create the DER encoding. " + aSN_Exception.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SemanticsInformation)) {
            return false;
        }
        SemanticsInformation semanticsInformation = (SemanticsInformation)object;
        if (this.b != null ? !this.b.equals(semanticsInformation.b) : semanticsInformation.b != null) {
            return false;
        }
        return !(this.a != null ? !CertJUtils.byteArraysEqual(this.a, semanticsInformation.a) : semanticsInformation.a != null);
    }

    public Object clone() throws CloneNotSupportedException {
        SemanticsInformation semanticsInformation = new SemanticsInformation();
        if (this.b != null) {
            semanticsInformation.b = (GeneralNames)this.b.clone();
        }
        if (this.a != null) {
            semanticsInformation.a = new byte[this.a.length];
            System.arraycopy(this.a, 0, semanticsInformation.a, 0, this.a.length);
        }
        try {
            if (this.c != null) {
                semanticsInformation.a();
            }
        }
        catch (NameException nameException) {
            throw new CloneNotSupportedException("Cannot clone SemanticsInformation object. " + nameException.getMessage());
        }
        return semanticsInformation;
    }
}

