/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.ExtensionDescriptor;
import com.adobe.air.validator.DescriptorValidator;
import com.adobe.air.validator.ExtensionDescriptorValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionDescriptorValidator25
extends ExtensionDescriptorValidator {
    private static final Pattern namePattern = Pattern.compile("[A-Za-z0-9\\-\\.]{1,255}");
    private final DescriptorValidator.ElementInfo ROOT_ELEMENT_INFO;
    public static String DEPLOYMENT_MODEL_APPLICATION = "applicationDeployment";
    public static String DEPLOYMENT_MODEL_DEVICE = "deviceDeployment";
    private String _id;
    private String _versionNumber = "";
    private String _name = null;
    private String _copyright = null;
    private HashMap<String, ExtensionDescriptor.Platform> _platforms = new HashMap();
    private HashMap<String, ExtensionDescriptor.Platform> _appDeployedPlatforms = new HashMap();
    private ExtensionDescriptor.Platform _platform;
    private Set<String> _nameLangs = new HashSet<String>();
    private Set<String> _descriptionLangs = new HashSet<String>();

    public ExtensionDescriptorValidator25() {
        this.ROOT_ELEMENT_INFO = this.createElementInfoTree();
    }

    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = new DescriptorValidator.ElementInfo("extension", 1, 1);
        root.addChild(new DescriptorValidator.ElementInfo("id", 1, 1));
        root.addChild(new DescriptorValidator.ElementInfo("name", 0, 1));
        DescriptorValidator.ElementInfo temp = root.getChild("name");
        temp.contentTypeMixed = true;
        temp.addChild(new DescriptorValidator.ElementInfo("text", 0, -1));
        temp = temp.getChild("text");
        temp.addAttribute(new DescriptorValidator.AttributeInfo("xml:lang", true));
        root.addChild(new DescriptorValidator.ElementInfo("description", 0, 1));
        temp = root.getChild("description");
        temp.contentTypeMixed = true;
        temp.addChild(new DescriptorValidator.ElementInfo("text", 0, -1));
        temp = temp.getChild("text");
        temp.addAttribute(new DescriptorValidator.AttributeInfo("xml:lang", true));
        root.addChild(new DescriptorValidator.ElementInfo("copyright", 0, 1));
        root.addChild(new DescriptorValidator.ElementInfo("versionNumber", 1, 1));
        root.addChild(new DescriptorValidator.ElementInfo("platforms", 1, 1));
        temp = root.getChild("platforms");
        temp.addChild(new DescriptorValidator.ElementInfo("platform", 1, -1, DescriptorValidator.ElementInfo.VALIDATE));
        temp = temp.getChild("platform");
        temp.addAttribute(new DescriptorValidator.AttributeInfo("name", true));
        temp.addChild(new DescriptorValidator.ElementInfo("deviceDeployment", 0, 1, DescriptorValidator.ElementInfo.VALIDATE));
        temp.addChild(new DescriptorValidator.ElementInfo("applicationDeployment", 0, 1, DescriptorValidator.ElementInfo.VALIDATE));
        temp = temp.getChild("applicationDeployment");
        temp.addChild(new DescriptorValidator.ElementInfo("nativeLibrary", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("initializer", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("finalizer", 0, 1));
        return root;
    }

    @Override
    protected DescriptorValidator.ElementInfo getRootElementInfo() {
        return this.ROOT_ELEMENT_INFO;
    }

    @Override
    protected boolean validateAttribute(String attributePath, String value) {
        if (attributePath.equals("extension.platforms.platform@name")) {
            if (!namePattern.matcher(value).matches()) {
                this.dispatchError(105, new String[]{attributePath});
            }
            if (this._platform == null) {
                this._platform = new ExtensionDescriptor.Platform();
            }
            if (this._platforms.containsKey(value)) {
                this.dispatchError(109, new String[]{"platform", value});
            }
            this._platform.name = value;
        }
        if (attributePath.equals("extension.name.text@xml:lang")) {
            if (this._nameLangs.contains(value)) {
                this.dispatchError(108, new String[]{attributePath, value});
            } else if (DescriptorValidator.validateLanguageType(value)) {
                this._nameLangs.add(value);
            } else {
                return false;
            }
        }
        if (attributePath.equals("extension.description.text@xml:lang")) {
            if (this._descriptionLangs.contains(value)) {
                this.dispatchError(108, new String[]{attributePath, value});
            } else if (DescriptorValidator.validateLanguageType(value)) {
                this._descriptionLangs.add(value);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean validateElement(String elementPath, String value) {
        boolean valid = true;
        if (elementPath.equals("extension.id")) {
            this._id = value;
            return DescriptorValidator.validateAppId(value);
        }
        if (elementPath.equals("extension.versionNumber")) {
            this._versionNumber = value;
            return DescriptorValidator.validateVersionNumber(value);
        }
        if (elementPath.equals("extension.name")) {
            this._name = value;
        }
        if (elementPath.equals("extension.copyright")) {
            this._copyright = value;
        }
        if (elementPath.equals("extension.platforms.platform")) {
            if (this._platform == null || this._platform.deploymentModel == null) {
                this.dispatchError(104, new String[]{"'Deployment model'"});
            } else if (this._platform.deploymentModel.equals(DEPLOYMENT_MODEL_APPLICATION)) {
                if (this._platform.name.equals("default")) {
                    if (this._platform.nativeLibrary != null || this._platform.initializer != null || this._platform.finalizer != null) {
                        this.dispatchError(115, null);
                    }
                } else {
                    if (this._platform.nativeLibrary != null && this._platform.initializer == null || this._platform.nativeLibrary == null && this._platform.initializer != null) {
                        this.dispatchError(113, null);
                    }
                    if (this._platform.nativeLibrary == null && this._platform.finalizer != null) {
                        this.dispatchError(114, null);
                    }
                }
                this._platforms.put(this._platform.name, this._platform);
                this._appDeployedPlatforms.put(this._platform.name, this._platform);
            } else if (this._platform.deploymentModel.equals(DEPLOYMENT_MODEL_DEVICE)) {
                this._platforms.put(this._platform.name, this._platform);
            }
            this._platform = null;
        }
        if (elementPath.equals("extension.platforms.platform.deviceDeployment")) {
            if (this._platform.deploymentModel != null) {
                return false;
            }
            this._platform.deploymentModel = "deviceDeployment";
        }
        if (elementPath.equals("extension.platforms.platform.applicationDeployment")) {
            if (this._platform.deploymentModel != null) {
                return false;
            }
            this._platform.deploymentModel = "applicationDeployment";
        }
        if (elementPath.equals("extension.platforms.platform.applicationDeployment.nativeLibrary")) {
            if (!namePattern.matcher(value).matches()) {
                this.dispatchError(105, new String[]{elementPath});
            }
            this._platform.nativeLibrary = value;
        }
        if (elementPath.equals("extension.platforms.platform.applicationDeployment.initializer")) {
            if (!namePattern.matcher(value).matches()) {
                this.dispatchError(105, new String[]{elementPath});
            }
            this._platform.initializer = value;
        }
        if (elementPath.equals("extension.platforms.platform.applicationDeployment.finalizer")) {
            if (!namePattern.matcher(value).matches()) {
                this.dispatchError(105, new String[]{elementPath});
            }
            this._platform.finalizer = value;
        }
        return valid;
    }

    @Override
    protected void finalizeValidation() throws SAXException {
        if (this._platforms.size() == 0) {
            this.dispatchError(110, new String[]{"platform"});
        }
    }

    @Override
    protected String getNamespace() {
        return "http://ns.adobe.com/air/extension/2.5";
    }

    public String id() {
        return this._id;
    }

    public String versionNumber() {
        return this._versionNumber;
    }

    public String name() {
        return this._name;
    }

    public String copyright() {
        return this._copyright;
    }

    public Map<String, ExtensionDescriptor.Platform> platforms() {
        return Collections.unmodifiableMap(this._platforms);
    }

    public Map<String, ExtensionDescriptor.Platform> applicationDeployedPlatforms() {
        return Collections.unmodifiableMap(this._appDeployedPlatforms);
    }
}

