/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.ADTException;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.ApplicationPackager;
import com.adobe.air.ipa.IPAOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;

public final class IPAPackager
extends ApplicationPackager {
    public static final ApplicationDescriptor.ValidationParams IPA_VALIDATION_PARAMS = new ApplicationDescriptor.ValidationParams("http://ns.adobe.com/air/application/2.0", new String[]{"mobileDevice"}, false, true, false);

    public IPAPackager() {
        super("AIR", "iPhone-ARM", false, false);
        this.setStream(new IPAOutputStream());
    }

    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("air");
    }

    protected ApplicationDescriptor.ValidationParams getValidationParams() {
        return IPA_VALIDATION_PARAMS;
    }

    public void setOptimizeLevel(int optLevel) {
        this.getIPAStream().setOptimizeLevel(optLevel);
    }

    public void setCompressSWF(boolean compressFlag) {
        this.getIPAStream().setCompressSWF(compressFlag);
    }

    public void setVerbose(int verbosity) {
        this.getIPAStream().setVerbose(verbosity);
    }

    public void setDebug(boolean debugFlag) {
        this.getIPAStream().setDebug(debugFlag);
    }

    public void setNoStrip(boolean stripFlag) {
        this.getIPAStream().setNoStrip(stripFlag);
    }

    public void setDebugRuntime(boolean debugRuntimeFlag) {
        this.getIPAStream().setDebugRuntime(debugRuntimeFlag);
    }

    public void setDebugBuiltins(boolean debugBuiltinsFlag) {
        this.getIPAStream().setDebugBuiltins(debugBuiltinsFlag);
    }

    public void setForOutgoingDebuggingConnection(String debugHost, int debugPort) {
        this.getIPAStream().setForOutgoingDebuggingConnection(debugHost, debugPort);
    }

    public void setUseInterpreter(boolean interpreterFlag) {
        this.getIPAStream().setUseInterpreter(interpreterFlag);
    }

    public void setDryRun(boolean dryRun) {
        this.getIPAStream().setDryRun(dryRun);
    }

    public void setTarget(String target) {
        this.getIPAStream().setTarget(target);
    }

    public void setSDKLocation(String location) {
        this.getIPAStream().setSDKLocation(location);
    }

    public void setRemoteContentURI(String remoteContent) {
        this.getIPAStream().setRemoteContentURI(remoteContent);
    }

    public void setTimeout(int timeoutSeconds) {
        this.getIPAStream().setTimeout(timeoutSeconds);
    }

    public void addExtraABC(String abc) {
        this.getIPAStream().addExtraABC(abc);
    }

    public void addLinkerOption(String linkoption) {
        this.getIPAStream().addLinkerOption(linkoption);
    }

    public void compileShellApp() throws IOException {
        this.getIPAStream().compileShellApp();
    }

    public void setPackageConfiguration(String configType) {
        this.getIPAStream().setPackageConfiguration(configType);
    }

    public void setMobileProvisioningProfile(File profile) {
        this.getIPAStream().setMobileProvisioningProfile(profile);
    }

    public void createIPA() throws GeneralSecurityException, IOException {
        this.createPackage();
    }

    public void createPackage() throws IOException, GeneralSecurityException {
        if (System.getProperty("os.name").indexOf("Mac") != -1) {
            String[] versionNumbers = System.getProperty("os.version").split("\\.");
            int majorVersion = Integer.parseInt(versionNumbers[0]);
            int minorVersion = Integer.parseInt(versionNumbers[1]);
            if (majorVersion < 10 || majorVersion == 10 && minorVersion < 5) {
                throw new ADTException("IPA packaging is not supported on mac 10.4 and earlier", 5);
            }
        }
        super.createPackage();
    }

    public void setValidate(boolean validate) {
        super.setValidate(validate);
    }

    private IPAOutputStream getIPAStream() {
        return (IPAOutputStream)this.getStream();
    }
}

