/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.max;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.junit.experimental.max.CouldNotReadCoreException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Map<String, Long> fDurations = new HashMap<String, Long>();
    public final Map<String, Long> fFailureTimestamps = new HashMap<String, Long>();
    public final File fFolder;

    public static MaxHistory forFolder(File storedResults) {
        try {
            if (storedResults.exists()) {
                return MaxHistory.readHistory(storedResults);
            }
        }
        catch (CouldNotReadCoreException e2) {
            e2.printStackTrace();
            storedResults.delete();
        }
        return new MaxHistory(storedResults);
    }

    private static MaxHistory readHistory(File storedResults) throws CouldNotReadCoreException {
        ObjectInputStream stream;
        try {
            stream = new ObjectInputStream(new FileInputStream(storedResults));
        }
        catch (IOException e2) {
            throw new CouldNotReadCoreException(e2);
        }
        try {
            MaxHistory e2 = (MaxHistory)stream.readObject();
            return e2;
        }
        catch (Exception e3) {
            throw new CouldNotReadCoreException(e3);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e4) {
                throw new CouldNotReadCoreException(e4);
            }
        }
    }

    public MaxHistory(File storedResults) {
        this.fFolder = storedResults;
    }

    public File getFile() {
        return this.fFolder;
    }

    public void save() throws IOException {
        ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(this.fFolder));
        stream.writeObject(this);
        stream.close();
    }

    Long getFailureTimestamp(Description key) {
        return this.fFailureTimestamps.get(key.toString());
    }

    void putTestFailureTimestamp(Description key, long end) {
        this.fFailureTimestamps.put(key.toString(), end);
    }

    boolean isNewTest(Description key) {
        return !this.fDurations.containsKey(key.toString());
    }

    Long getTestDuration(Description key) {
        return this.fDurations.get(key.toString());
    }

    void putTestDuration(Description description, long duration) {
        this.fDurations.put(description.toString(), duration);
    }

    public RememberingListener listener() {
        return new RememberingListener();
    }

    public Comparator<Description> testComparator() {
        return new TestComparator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestComparator
    implements Comparator<Description> {
        private TestComparator() {
        }

        @Override
        public int compare(Description o1, Description o2) {
            if (MaxHistory.this.isNewTest(o1)) {
                return -1;
            }
            if (MaxHistory.this.isNewTest(o2)) {
                return 1;
            }
            int result = this.getFailure(o2).compareTo(this.getFailure(o1));
            return result != 0 ? result : MaxHistory.this.getTestDuration(o1).compareTo(MaxHistory.this.getTestDuration(o2));
        }

        private Long getFailure(Description key) {
            Long result = MaxHistory.this.getFailureTimestamp(key);
            if (result == null) {
                return 0L;
            }
            return result;
        }
    }

    private final class RememberingListener
    extends RunListener {
        private long overallStart = System.currentTimeMillis();
        private Map<Description, Long> starts = new HashMap<Description, Long>();

        private RememberingListener() {
        }

        public void testStarted(Description description) throws Exception {
            this.starts.put(description, System.nanoTime());
        }

        public void testFinished(Description description) throws Exception {
            long end = System.nanoTime();
            long start = this.starts.get(description);
            MaxHistory.this.putTestDuration(description, end - start);
        }

        public void testFailure(Failure failure) throws Exception {
            MaxHistory.this.putTestFailureTimestamp(failure.getDescription(), this.overallStart);
        }
    }
}

