/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.max;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.experimental.max.MaxHistory;
import org.junit.internal.requests.SortingRequest;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxCore {
    public final MaxHistory fHistory;

    public static MaxCore forFolder(String fileName) {
        return MaxCore.storedLocally(new File(fileName));
    }

    public static MaxCore storedLocally(File storedResults) {
        return new MaxCore(storedResults);
    }

    public MaxCore(File storedResults) {
        this.fHistory = MaxHistory.forFolder(storedResults);
    }

    public Result run(Class<?> testClass) {
        return this.run(Request.aClass(testClass));
    }

    public Result run(Request request) {
        return this.run(request, new JUnitCore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result run(Request request, JUnitCore core) {
        core.addListener(this.fHistory.listener());
        try {
            Result result = core.run(this.sortRequest(request).getRunner());
            return result;
        }
        finally {
            try {
                this.fHistory.save();
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    public Request sortRequest(Request request) {
        if (request instanceof SortingRequest) {
            return request;
        }
        List<Description> leaves = this.findLeaves(request);
        Collections.sort(leaves, this.fHistory.testComparator());
        return this.constructLeafRequest(leaves);
    }

    public Request constructLeafRequest(List<Description> leaves) {
        final ArrayList<Runner> runners = new ArrayList<Runner>();
        for (Description each : leaves) {
            runners.add(this.buildRunner(each));
        }
        return new Request(){

            public Runner getRunner() {
                try {
                    return new Suite((Class)null, runners){};
                }
                catch (InitializationError e2) {
                    return new ErrorReportingRunner(null, e2);
                }
            }
        };
    }

    public Runner buildRunner(Description each) {
        Class<?> type;
        if (each.toString().equals("TestSuite with 0 tests")) {
            try {
                return new Suite(null, (Class<?>[])new Class[0]);
            }
            catch (InitializationError e2) {
                e2.printStackTrace();
            }
        }
        if ((type = each.getTestClass()) == null) {
            throw new RuntimeException("Can't build a runner from description [" + each + "]");
        }
        String methodName = each.getMethodName();
        if (methodName == null) {
            return Request.aClass(type).getRunner();
        }
        return Request.method(type, methodName).getRunner();
    }

    public List<Description> sortedLeavesForTest(Request request) {
        return this.findLeaves(this.sortRequest(request));
    }

    public List<Description> findLeaves(Request request) {
        ArrayList<Description> results = new ArrayList<Description>();
        this.findLeaves(request.getRunner().getDescription(), results);
        return results;
    }

    public void findLeaves(Description description, List<Description> results) {
        if (description.getChildren().isEmpty()) {
            results.add(description);
        } else {
            for (Description each : description.getChildren()) {
                this.findLeaves(each, results);
            }
        }
    }
}

