/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

public class EncodedValueUtils {
    public static byte getRequiredBytesForSignedIntegralValue(long value) {
        int requiredBits = 65 - Long.numberOfLeadingZeros(value ^ value >> 63);
        return (byte)(requiredBits + 7 >> 3);
    }

    public static long decodeSignedIntegralValue(byte[] bytes) {
        long value = 0L;
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            value |= (long)(bytes[i2] & 0xFF) << i2 * 8;
        }
        int shift = (8 - bytes.length) * 8;
        return value << shift >> shift;
    }

    public static byte[] encodeSignedIntegralValue(long value) {
        int requiredBytes = EncodedValueUtils.getRequiredBytesForSignedIntegralValue(value);
        byte[] bytes = new byte[requiredBytes];
        for (int i2 = 0; i2 < requiredBytes; ++i2) {
            bytes[i2] = (byte)value;
            value >>= 8;
        }
        return bytes;
    }

    public static byte getRequiredBytesForUnsignedIntegralValue(long value) {
        int requiredBits = 64 - Long.numberOfLeadingZeros(value);
        if (requiredBits == 0) {
            requiredBits = 1;
        }
        return (byte)(requiredBits + 7 >> 3);
    }

    public static long decodeUnsignedIntegralValue(byte[] bytes) {
        long value = 0L;
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            value |= (long)(bytes[i2] & 0xFF) << i2 * 8;
        }
        return value;
    }

    public static byte[] encodeUnsignedIntegralValue(long value) {
        int requiredBytes = EncodedValueUtils.getRequiredBytesForUnsignedIntegralValue(value);
        byte[] bytes = new byte[requiredBytes];
        for (int i2 = 0; i2 < requiredBytes; ++i2) {
            bytes[i2] = (byte)value;
            value >>= 8;
        }
        return bytes;
    }

    public static int getRequiredBytesForRightZeroExtendedValue(long value) {
        int requiredBits = 64 - Long.numberOfTrailingZeros(value);
        if (requiredBits == 0) {
            requiredBits = 1;
        }
        return requiredBits + 7 >> 3;
    }

    public static long decodeRightZeroExtendedValue(byte[] bytes) {
        long value = 0L;
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            value |= (long)(bytes[i2] & 0xFF) << i2 * 8;
        }
        return value << (8 - bytes.length) * 8;
    }

    public static byte[] encodeRightZeroExtendedValue(long value) {
        int requiredBytes = EncodedValueUtils.getRequiredBytesForRightZeroExtendedValue(value);
        value >>= 64 - requiredBytes * 8;
        byte[] bytes = new byte[requiredBytes];
        for (int i2 = 0; i2 < requiredBytes; ++i2) {
            bytes[i2] = (byte)value;
            value >>= 8;
        }
        return bytes;
    }
}

