/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class ShortEncodedValue
extends EncodedValue {
    public final short value;

    protected ShortEncodedValue(Input in, byte valueArg) {
        this.value = (short)EncodedValueUtils.decodeSignedIntegralValue(in.readBytes(valueArg + 1));
    }

    public ShortEncodedValue(short value) {
        this.value = value;
    }

    public void writeValue(AnnotatedOutput out) {
        byte[] bytes = EncodedValueUtils.encodeSignedIntegralValue(this.value);
        if (out.annotates()) {
            out.annotate(1, "value_type=" + ValueType.VALUE_SHORT.name() + ",value_arg=" + (bytes.length - 1));
            out.annotate(bytes.length, "value: 0x" + Integer.toHexString(this.value) + " (" + this.value + ")");
        }
        out.writeByte(ValueType.VALUE_SHORT.value | bytes.length - 1 << 5);
        out.write(bytes);
    }

    public int placeValue(int offset) {
        return offset + EncodedValueUtils.getRequiredBytesForSignedIntegralValue(this.value) + 1;
    }

    protected int compareValue(EncodedValue o2) {
        ShortEncodedValue other = (ShortEncodedValue)o2;
        return this.value < other.value ? -1 : (this.value > other.value ? 1 : 0);
    }

    public ValueType getValueType() {
        return ValueType.VALUE_SHORT;
    }

    public int hashCode() {
        return this.value;
    }
}

