/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import java.util.Iterator;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.MultiOffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackedSwitchDataPseudoInstruction
extends Instruction
implements MultiOffsetInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int firstKey;
    private int[] targets;

    @Override
    public int getSize(int codeAddress) {
        return this.getTargetCount() * 2 + 4 + codeAddress % 2;
    }

    public PackedSwitchDataPseudoInstruction(int firstKey, int[] targets) {
        super(Opcode.NOP);
        if (targets.length > 65535) {
            throw new RuntimeException("The packed-switch data contains too many elements. The maximum number of switch elements is 65535");
        }
        this.firstKey = firstKey;
        this.targets = targets;
    }

    public PackedSwitchDataPseudoInstruction(byte[] buffer, int bufferIndex) {
        super(Opcode.NOP);
        byte opcodeByte = buffer[bufferIndex];
        if (opcodeByte != 0) {
            throw new RuntimeException("Invalid opcode byte for a PackedSwitchData pseudo-instruction");
        }
        byte subopcodeByte = buffer[bufferIndex + 1];
        if (subopcodeByte != 1) {
            throw new RuntimeException("Invalid sub-opcode byte for a PackedSwitchData pseudo-instruction");
        }
        int targetCount = NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 2);
        this.firstKey = NumberUtils.decodeInt(buffer, bufferIndex + 4);
        this.targets = new int[targetCount];
        for (int i2 = 0; i2 < targetCount; ++i2) {
            this.targets[i2] = NumberUtils.decodeInt(buffer, bufferIndex + 8 + 4 * i2);
        }
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.alignTo(4);
        out.writeByte(0);
        out.writeByte(1);
        out.writeShort(this.targets.length);
        out.writeInt(this.firstKey);
        for (int target : this.targets) {
            out.writeInt(target);
        }
    }

    @Override
    protected void annotateInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.annotate(this.getSize(currentCodeAddress) * 2, "[0x" + Integer.toHexString(currentCodeAddress) + "] " + "packed-switch-data instruction");
    }

    @Override
    public void updateTarget(int targetIndex, int targetAddressOffset) {
        this.targets[targetIndex] = targetAddressOffset;
    }

    @Override
    public Format getFormat() {
        return Format.PackedSwitchData;
    }

    public int getTargetCount() {
        return this.targets.length;
    }

    public int getFirstKey() {
        return this.firstKey;
    }

    @Override
    public int[] getTargets() {
        return this.targets;
    }

    public Iterator<PackedSwitchTarget> iterateKeysAndTargets() {
        return new Iterator<PackedSwitchTarget>(){
            final int targetCount;
            int i;
            int value;
            PackedSwitchTarget packedSwitchTarget;
            {
                this.targetCount = PackedSwitchDataPseudoInstruction.this.getTargetCount();
                this.i = 0;
                this.value = PackedSwitchDataPseudoInstruction.this.getFirstKey();
                this.packedSwitchTarget = new PackedSwitchTarget();
            }

            @Override
            public boolean hasNext() {
                return this.i < this.targetCount;
            }

            @Override
            public PackedSwitchTarget next() {
                this.packedSwitchTarget.value = this.value++;
                this.packedSwitchTarget.targetAddressOffset = PackedSwitchDataPseudoInstruction.this.targets[this.i];
                ++this.i;
                return this.packedSwitchTarget;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            if (opcode != Opcode.NOP) {
                throw new RuntimeException("The opcode for a PackedSwitchDataPseudoInstruction must be NOP");
            }
            return new PackedSwitchDataPseudoInstruction(buffer, bufferIndex);
        }
    }

    public static class PackedSwitchTarget {
        public int value;
        public int targetAddressOffset;
    }
}

