/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.AnnotationAdaptor;
import org.jf.baksmali.Adaptors.BlankMethodItem;
import org.jf.baksmali.Adaptors.CatchMethodItem;
import org.jf.baksmali.Adaptors.CommentMethodItem;
import org.jf.baksmali.Adaptors.CommentedOutMethodItem;
import org.jf.baksmali.Adaptors.DebugMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItemFactory;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.LocalDebugMethodItem;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.ParameterAdaptor;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.MethodAnalyzer;
import org.jf.dexlib.Code.Analysis.RegisterType;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.Debug.DebugInstructionIterator;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.SparseIntArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDefinition {
    private final StringTemplateGroup stg;
    private final ClassDataItem.EncodedMethod encodedMethod;
    private final MethodAnalyzer methodAnalyzer;
    private final LabelCache labelCache = new LabelCache();
    private final SparseIntArray packedSwitchMap;
    private final SparseIntArray sparseSwitchMap;
    private final SparseIntArray instructionMap;
    private final int registerCount;

    public MethodDefinition(StringTemplateGroup stg, ClassDataItem.EncodedMethod encodedMethod) {
        try {
            this.stg = stg;
            this.encodedMethod = encodedMethod;
            if (encodedMethod.codeItem != null) {
                this.methodAnalyzer = new MethodAnalyzer(encodedMethod, baksmali.deodex);
                List<AnalyzedInstruction> instructions = this.methodAnalyzer.getInstructions();
                this.packedSwitchMap = new SparseIntArray(1);
                this.sparseSwitchMap = new SparseIntArray(1);
                this.instructionMap = new SparseIntArray(instructions.size());
                this.registerCount = encodedMethod.codeItem.getRegisterCount();
                int currentCodeAddress = 0;
                for (int i2 = 0; i2 < instructions.size(); ++i2) {
                    AnalyzedInstruction instruction = instructions.get(i2);
                    if (instruction.getInstruction().opcode == Opcode.PACKED_SWITCH) {
                        this.packedSwitchMap.append(currentCodeAddress + ((OffsetInstruction)((Object)instruction.getInstruction())).getTargetAddressOffset(), currentCodeAddress);
                    } else if (instruction.getInstruction().opcode == Opcode.SPARSE_SWITCH) {
                        this.sparseSwitchMap.append(currentCodeAddress + ((OffsetInstruction)((Object)instruction.getInstruction())).getTargetAddressOffset(), currentCodeAddress);
                    }
                    this.instructionMap.append(currentCodeAddress, i2);
                    currentCodeAddress += instruction.getInstruction().getSize(currentCodeAddress);
                }
            } else {
                this.packedSwitchMap = null;
                this.sparseSwitchMap = null;
                this.instructionMap = null;
                this.methodAnalyzer = null;
                this.registerCount = 0;
            }
        }
        catch (Exception ex) {
            throw ExceptionWithContext.withContext(ex, String.format("Error while processing method %s", encodedMethod.method.getMethodString()));
        }
    }

    public StringTemplate createTemplate(AnnotationSetItem annotationSet, AnnotationSetRefList parameterAnnotations) {
        CodeItem codeItem = this.encodedMethod.codeItem;
        StringTemplate template = this.stg.getInstanceOf("method");
        template.setAttribute("AccessFlags", MethodDefinition.getAccessFlags(this.encodedMethod));
        template.setAttribute("MethodName", this.encodedMethod.method.getMethodName().getStringValue());
        template.setAttribute("Prototype", this.encodedMethod.method.getPrototype().getPrototypeString());
        template.setAttribute("HasCode", codeItem != null);
        template.setAttribute("RegistersDirective", baksmali.useLocalsDirective ? ".locals" : ".registers");
        template.setAttribute("RegisterCount", codeItem == null ? "0" : Integer.toString(MethodDefinition.getRegisterCount(this.encodedMethod)));
        template.setAttribute("Parameters", MethodDefinition.getParameters(this.stg, codeItem, parameterAnnotations));
        template.setAttribute("Annotations", MethodDefinition.getAnnotations(this.stg, annotationSet));
        template.setAttribute("MethodItems", this.getMethodItems());
        return template;
    }

    private static int getRegisterCount(ClassDataItem.EncodedMethod encodedMethod) {
        int totalRegisters = encodedMethod.codeItem.getRegisterCount();
        if (baksmali.useLocalsDirective) {
            int parameterRegisters = encodedMethod.method.getPrototype().getParameterRegisterCount();
            if ((encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0) {
                ++parameterRegisters;
            }
            return totalRegisters - parameterRegisters;
        }
        return totalRegisters;
    }

    private static List<String> getAccessFlags(ClassDataItem.EncodedMethod encodedMethod) {
        ArrayList<String> accessFlags = new ArrayList<String>();
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForMethod(encodedMethod.accessFlags)) {
            accessFlags.add(accessFlag.toString());
        }
        return accessFlags;
    }

    private static List<StringTemplate> getParameters(StringTemplateGroup stg, CodeItem codeItem, AnnotationSetRefList parameterAnnotations) {
        DebugInfoItem debugInfoItem = null;
        if (baksmali.outputDebugInfo && codeItem != null) {
            debugInfoItem = codeItem.getDebugInfo();
        }
        int parameterCount = 0;
        ArrayList<AnnotationSetItem> annotations = new ArrayList<AnnotationSetItem>();
        if (parameterAnnotations != null) {
            AnnotationSetItem[] _annotations = parameterAnnotations.getAnnotationSets();
            if (_annotations != null) {
                annotations.addAll(Arrays.asList(_annotations));
            }
            parameterCount = annotations.size();
        }
        ArrayList<String> parameterNames = new ArrayList<String>();
        if (debugInfoItem != null) {
            StringIdItem[] _parameterNames = debugInfoItem.getParameterNames();
            if (_parameterNames != null) {
                for (StringIdItem parameterName : _parameterNames) {
                    parameterNames.add(parameterName == null ? null : parameterName.getStringValue());
                }
            }
            if (parameterCount < parameterNames.size()) {
                parameterCount = parameterNames.size();
            }
        }
        ArrayList<StringTemplate> parameters = new ArrayList<StringTemplate>();
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            AnnotationSetItem annotationSet = null;
            if (i2 < annotations.size()) {
                annotationSet = (AnnotationSetItem)annotations.get(i2);
            }
            String parameterName = null;
            if (i2 < parameterNames.size()) {
                parameterName = (String)parameterNames.get(i2);
            }
            parameters.add(ParameterAdaptor.createTemplate(stg, parameterName, annotationSet));
        }
        return parameters;
    }

    public LabelCache getLabelCache() {
        return this.labelCache;
    }

    public ValidationException getValidationException() {
        if (this.methodAnalyzer == null) {
            return null;
        }
        return this.methodAnalyzer.getValidationException();
    }

    public int getPackedSwitchBaseAddress(int packedSwitchDataAddress) {
        int packedSwitchBaseAddress = this.packedSwitchMap.get(packedSwitchDataAddress, -1);
        if (packedSwitchBaseAddress == -1) {
            throw new RuntimeException("Could not find the packed switch statement corresponding to the packed switch data at address " + packedSwitchDataAddress);
        }
        return packedSwitchBaseAddress;
    }

    public int getSparseSwitchBaseAddress(int sparseSwitchDataAddress) {
        int sparseSwitchBaseAddress = this.sparseSwitchMap.get(sparseSwitchDataAddress, -1);
        if (sparseSwitchBaseAddress == -1) {
            throw new RuntimeException("Could not find the sparse switch statement corresponding to the sparse switch data at address " + sparseSwitchDataAddress);
        }
        return sparseSwitchBaseAddress;
    }

    private static List<StringTemplate> getAnnotations(StringTemplateGroup stg, AnnotationSetItem annotationSet) {
        if (annotationSet == null) {
            return null;
        }
        ArrayList<StringTemplate> annotationAdaptors = new ArrayList<StringTemplate>();
        for (AnnotationItem annotationItem : annotationSet.getAnnotations()) {
            annotationAdaptors.add(AnnotationAdaptor.createTemplate(stg, annotationItem));
        }
        return annotationAdaptors;
    }

    private boolean isInstructionPaddingNop(List<AnalyzedInstruction> instructions, AnalyzedInstruction instruction) {
        if (instruction.getInstruction().opcode != Opcode.NOP || instruction.getInstruction().getFormat().variableSizeFormat) {
            return false;
        }
        if (instruction.getInstructionIndex() == instructions.size() - 1) {
            return false;
        }
        AnalyzedInstruction nextInstruction = instructions.get(instruction.getInstructionIndex() + 1);
        return nextInstruction.getInstruction().getFormat().variableSizeFormat;
    }

    private List<MethodItem> getMethodItems() {
        ArrayList<MethodItem> methodItems = new ArrayList<MethodItem>();
        if (this.encodedMethod.codeItem == null) {
            return methodItems;
        }
        if (baksmali.registerInfo != 0 || baksmali.deodex || baksmali.verify) {
            this.methodAnalyzer.analyze();
            ValidationException validationException = this.methodAnalyzer.getValidationException();
            if (validationException != null) {
                methodItems.add(new CommentMethodItem(this.stg, String.format("ValidationException: %s", validationException.getMessage()), validationException.getCodeAddress(), -2.147483648E9));
            } else if (baksmali.verify) {
                this.methodAnalyzer.verify();
                validationException = this.methodAnalyzer.getValidationException();
                if (validationException != null) {
                    methodItems.add(new CommentMethodItem(this.stg, String.format("ValidationException: %s", validationException.getMessage()), validationException.getCodeAddress(), -2.147483648E9));
                }
            }
        }
        List<AnalyzedInstruction> instructions = this.methodAnalyzer.getInstructions();
        AnalyzedInstruction lastInstruction = null;
        for (int i2 = instructions.size() - 1; i2 >= 0; --i2) {
            AnalyzedInstruction instruction = instructions.get(i2);
            if (instruction.isDead()) continue;
            lastInstruction = instruction;
            break;
        }
        BitSet printPreRegister = new BitSet(this.registerCount);
        BitSet printPostRegister = new BitSet(this.registerCount);
        boolean lastIsUnreachable = false;
        int currentCodeAddress = 0;
        for (int i3 = 0; i3 < instructions.size(); ++i3) {
            AnalyzedInstruction instruction = instructions.get(i3);
            InstructionMethodItem methodItem = InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, this.encodedMethod.codeItem, currentCodeAddress, instruction.isDead(), this.stg, instruction.getInstruction(), instruction == lastInstruction);
            boolean addedInstruction = false;
            if (instruction.isDead() && !instruction.getInstruction().getFormat().variableSizeFormat) {
                methodItems.add(new CommentedOutMethodItem(this.stg, methodItem));
                lastIsUnreachable = false;
                addedInstruction = true;
            } else if (instruction.getPredecessorCount() == 0 && !instruction.getInstruction().getFormat().variableSizeFormat && !this.isInstructionPaddingNop(instructions, instruction)) {
                if (!lastIsUnreachable) {
                    methodItems.add(new CommentMethodItem(this.stg, "Unreachable code", currentCodeAddress, Double.MIN_VALUE));
                }
                methodItems.add(new CommentedOutMethodItem(this.stg, methodItem));
                lastIsUnreachable = true;
            } else {
                methodItems.add(methodItem);
                lastIsUnreachable = false;
            }
            if (instruction.getInstruction().getFormat() == Format.UnresolvedNullReference) {
                methodItems.add(new CommentedOutMethodItem(this.stg, InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, this.encodedMethod.codeItem, currentCodeAddress, instruction.isDead(), this.stg, instruction.getOriginalInstruction(), false)));
            }
            if (i3 != instructions.size() - 1) {
                methodItems.add(new BlankMethodItem(this.stg, currentCodeAddress));
            }
            if (baksmali.addCodeOffsets) {
                methodItems.add(new CommentMethodItem(this.stg, String.format("@%x", currentCodeAddress), currentCodeAddress, -1000.0));
            }
            if (baksmali.registerInfo != 0 && !instruction.getInstruction().getFormat().variableSizeFormat) {
                String comment;
                printPreRegister.clear();
                printPostRegister.clear();
                if ((baksmali.registerInfo & 1) != 0) {
                    printPreRegister.set(0, this.registerCount);
                    printPostRegister.set(0, this.registerCount);
                } else {
                    if ((baksmali.registerInfo & 2) != 0) {
                        printPreRegister.set(0, this.registerCount);
                    } else {
                        if ((baksmali.registerInfo & 8) != 0) {
                            this.addArgsRegs(printPreRegister, instruction);
                        }
                        if ((baksmali.registerInfo & 0x20) != 0) {
                            this.addMergeRegs(printPreRegister, instruction);
                        } else if ((baksmali.registerInfo & 0x40) != 0 && (i3 == 0 || instruction.isBeginningInstruction())) {
                            this.addParamRegs(printPreRegister);
                        }
                    }
                    if ((baksmali.registerInfo & 4) != 0) {
                        printPostRegister.set(0, this.registerCount);
                    } else if ((baksmali.registerInfo & 0x10) != 0) {
                        this.addDestRegs(printPostRegister, instruction);
                    }
                }
                if ((baksmali.registerInfo & 0x40) != 0) {
                    this.addFullMergeRegs(printPreRegister, methodItems, this.methodAnalyzer, instruction, currentCodeAddress);
                }
                if (!printPreRegister.isEmpty() && (comment = this.getPreInstructionRegisterString(instruction, printPreRegister)) != null && comment.length() > 0) {
                    methodItems.add(new CommentMethodItem(this.stg, comment, currentCodeAddress, 99.9));
                }
                if (!printPostRegister.isEmpty() && (comment = this.getPostInstructionRegisterString(instruction, printPostRegister)) != null && comment.length() > 0) {
                    methodItems.add(new CommentMethodItem(this.stg, comment, currentCodeAddress, 100.1));
                }
            }
            currentCodeAddress += instruction.getInstruction().getSize(currentCodeAddress);
        }
        this.addTries(methodItems);
        this.addDebugInfo(methodItems);
        if (baksmali.useSequentialLabels) {
            this.setLabelSequentialNumbers();
        }
        for (LabelMethodItem labelMethodItem : this.labelCache.getLabels()) {
            if (labelMethodItem.isCommentedOut()) {
                methodItems.add(new CommentedOutMethodItem(this.stg, labelMethodItem));
                continue;
            }
            methodItems.add(labelMethodItem);
        }
        Collections.sort(methodItems);
        return methodItems;
    }

    private void addArgsRegs(BitSet printPreRegister, AnalyzedInstruction analyzedInstruction) {
        if (analyzedInstruction.getInstruction() instanceof RegisterRangeInstruction) {
            RegisterRangeInstruction instruction = (RegisterRangeInstruction)((Object)analyzedInstruction.getInstruction());
            printPreRegister.set(instruction.getStartRegister(), instruction.getStartRegister() + instruction.getRegCount());
        } else if (analyzedInstruction.getInstruction() instanceof FiveRegisterInstruction) {
            FiveRegisterInstruction instruction = (FiveRegisterInstruction)((Object)analyzedInstruction.getInstruction());
            byte regCount = instruction.getRegCount();
            switch (regCount) {
                case 5: {
                    printPreRegister.set(instruction.getRegisterA());
                }
                case 4: {
                    printPreRegister.set(instruction.getRegisterG());
                }
                case 3: {
                    printPreRegister.set(instruction.getRegisterF());
                }
                case 2: {
                    printPreRegister.set(instruction.getRegisterE());
                }
                case 1: {
                    printPreRegister.set(instruction.getRegisterD());
                }
            }
        } else if (analyzedInstruction.getInstruction() instanceof ThreeRegisterInstruction) {
            ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.getInstruction());
            printPreRegister.set(instruction.getRegisterA());
            printPreRegister.set(instruction.getRegisterB());
            printPreRegister.set(instruction.getRegisterC());
        } else if (analyzedInstruction.getInstruction() instanceof TwoRegisterInstruction) {
            TwoRegisterInstruction instruction = (TwoRegisterInstruction)((Object)analyzedInstruction.getInstruction());
            printPreRegister.set(instruction.getRegisterA());
            printPreRegister.set(instruction.getRegisterB());
        } else if (analyzedInstruction.getInstruction() instanceof SingleRegisterInstruction) {
            SingleRegisterInstruction instruction = (SingleRegisterInstruction)((Object)analyzedInstruction.getInstruction());
            printPreRegister.set(instruction.getRegisterA());
        }
    }

    private void addFullMergeRegs(BitSet printPreRegister, List<MethodItem> methodItems, MethodAnalyzer methodAnalyzer, AnalyzedInstruction instruction, int currentCodeAddress) {
        if (instruction.getPredecessorCount() <= 1) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int registerNum = 0; registerNum < this.registerCount; ++registerNum) {
            sb.setLength(0);
            sb.append(RegisterFormatter.formatRegister(this.encodedMethod.codeItem, registerNum));
            sb.append('=');
            sb.append(instruction.getPreInstructionRegisterType(registerNum));
            sb.append(":merge{");
            RegisterType mergedRegisterType = null;
            boolean addRegister = false;
            boolean first = true;
            for (AnalyzedInstruction predecessor : instruction.getPredecessors()) {
                RegisterType predecessorRegisterType = predecessor.getPostInstructionRegisterType(registerNum);
                if (!first) {
                    if (!addRegister) {
                        sb.append(',');
                        if (mergedRegisterType != predecessorRegisterType) {
                            addRegister = true;
                        }
                        mergedRegisterType = mergedRegisterType.merge(predecessorRegisterType);
                    }
                } else {
                    mergedRegisterType = predecessorRegisterType;
                }
                if (predecessor.getInstructionIndex() == -1) {
                    sb.append("Start:");
                } else {
                    sb.append("0x");
                    sb.append(Integer.toHexString(methodAnalyzer.getInstructionAddress(predecessor)));
                    sb.append(':');
                }
                sb.append(predecessorRegisterType.toString());
                first = false;
            }
            if (!addRegister) continue;
            sb.append("}");
            methodItems.add(new CommentMethodItem(this.stg, sb.toString(), currentCodeAddress, 99.8));
            printPreRegister.clear(registerNum);
        }
    }

    private void addMergeRegs(BitSet printPreRegister, AnalyzedInstruction instruction) {
        if (instruction.isBeginningInstruction()) {
            this.addParamRegs(printPreRegister);
        }
        if (instruction.getPredecessorCount() <= 1) {
            return;
        }
        for (int registerNum = 0; registerNum < this.registerCount; ++registerNum) {
            RegisterType mergedRegisterType = instruction.getPreInstructionRegisterType(registerNum);
            for (AnalyzedInstruction predecessor : instruction.getPredecessors()) {
                if (predecessor.getPostInstructionRegisterType(registerNum) == mergedRegisterType) continue;
                printPreRegister.set(registerNum);
            }
        }
    }

    private void addParamRegs(BitSet printPreRegister) {
        int registerCount = this.encodedMethod.codeItem.getRegisterCount();
        int parameterRegisterCount = this.encodedMethod.method.getPrototype().getParameterRegisterCount();
        if ((this.encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0) {
            ++parameterRegisterCount;
        }
        printPreRegister.set(registerCount - parameterRegisterCount, registerCount);
    }

    private void addDestRegs(BitSet printPostRegister, AnalyzedInstruction analyzedInstruction) {
        for (int registerNum = 0; registerNum < this.registerCount; ++registerNum) {
            if (analyzedInstruction.getPreInstructionRegisterType(registerNum) == analyzedInstruction.getPostInstructionRegisterType(registerNum)) continue;
            printPostRegister.set(registerNum);
        }
    }

    private String getPreInstructionRegisterString(AnalyzedInstruction instruction, BitSet registers) {
        StringBuilder sb = new StringBuilder();
        int registerNum = registers.nextSetBit(0);
        while (registerNum >= 0) {
            RegisterType registerType = instruction.getPreInstructionRegisterType(registerNum);
            sb.append(RegisterFormatter.formatRegister(this.encodedMethod.codeItem, registerNum));
            sb.append("=");
            if (registerType == null) {
                sb.append("null");
            } else {
                sb.append(registerType.toString());
            }
            sb.append(";");
            registerNum = registers.nextSetBit(registerNum + 1);
        }
        return sb.toString();
    }

    private String getPostInstructionRegisterString(AnalyzedInstruction instruction, BitSet registers) {
        StringBuilder sb = new StringBuilder();
        int registerNum = registers.nextSetBit(0);
        while (registerNum >= 0) {
            RegisterType registerType = instruction.getPostInstructionRegisterType(registerNum);
            sb.append(RegisterFormatter.formatRegister(this.encodedMethod.codeItem, registerNum));
            sb.append("=");
            if (registerType == null) {
                sb.append("null");
            } else {
                sb.append(registerType.toString());
            }
            sb.append(";");
            registerNum = registers.nextSetBit(registerNum + 1);
        }
        return sb.toString();
    }

    private void addTries(List<MethodItem> methodItems) {
        if (this.encodedMethod.codeItem == null || this.encodedMethod.codeItem.getTries() == null) {
            return;
        }
        Instruction[] instructions = this.encodedMethod.codeItem.getInstructions();
        for (CodeItem.TryItem tryItem : this.encodedMethod.codeItem.getTries()) {
            int catchAllAddress;
            int lastInstructionAddress;
            Instruction lastInstruction;
            int startAddress = tryItem.getStartCodeAddress();
            int endAddress = tryItem.getStartCodeAddress() + tryItem.getTryLength();
            int index = this.instructionMap.get(endAddress, -1);
            if (index == -1) {
                lastInstruction = instructions[instructions.length - 1];
                lastInstructionAddress = this.instructionMap.keyAt(this.instructionMap.size() - 1);
                if (endAddress != lastInstructionAddress + lastInstruction.getSize(lastInstructionAddress)) {
                    throw new RuntimeException("Invalid code offset " + endAddress + " for the try block end address");
                }
            } else {
                if (index == 0) {
                    throw new RuntimeException("Unexpected instruction index");
                }
                lastInstruction = instructions[index - 1];
                if (lastInstruction.getFormat().variableSizeFormat) {
                    throw new RuntimeException("This try block unexpectedly ends on a switch/array data block.");
                }
                lastInstructionAddress = endAddress - lastInstruction.getSize(0);
            }
            if ((catchAllAddress = tryItem.encodedCatchHandler.getCatchAllHandlerAddress()) != -1) {
                CatchMethodItem catchAllMethodItem = new CatchMethodItem(this.labelCache, lastInstructionAddress, this.stg, null, startAddress, endAddress, catchAllAddress);
                methodItems.add(catchAllMethodItem);
            }
            for (CodeItem.EncodedTypeAddrPair handler : tryItem.encodedCatchHandler.handlers) {
                CatchMethodItem catchMethodItem = new CatchMethodItem(this.labelCache, lastInstructionAddress, this.stg, handler.exceptionType, startAddress, endAddress, handler.getHandlerAddress());
                methodItems.add(catchMethodItem);
            }
        }
    }

    private void addDebugInfo(final List<MethodItem> methodItems) {
        if (this.encodedMethod.codeItem == null || this.encodedMethod.codeItem.getDebugInfo() == null) {
            return;
        }
        final CodeItem codeItem = this.encodedMethod.codeItem;
        DebugInfoItem debugInfoItem = codeItem.getDebugInfo();
        DebugInstructionIterator.DecodeInstructions(debugInfoItem, codeItem.getRegisterCount(), new DebugInstructionIterator.ProcessDecodedDebugInstructionDelegate(){

            public void ProcessStartLocal(int codeAddress, int length, int registerNum, StringIdItem name, TypeIdItem type) {
                methodItems.add(new LocalDebugMethodItem(codeItem, codeAddress, MethodDefinition.this.stg, "StartLocal", -1.0, registerNum, name, type, null));
            }

            public void ProcessStartLocalExtended(int codeAddress, int length, int registerNum, StringIdItem name, TypeIdItem type, StringIdItem signature) {
                methodItems.add(new LocalDebugMethodItem(codeItem, codeAddress, MethodDefinition.this.stg, "StartLocal", -1.0, registerNum, name, type, signature));
            }

            public void ProcessEndLocal(int codeAddress, int length, int registerNum, StringIdItem name, TypeIdItem type, StringIdItem signature) {
                methodItems.add(new LocalDebugMethodItem(codeItem, codeAddress, MethodDefinition.this.stg, "EndLocal", -1.0, registerNum, name, type, signature));
            }

            public void ProcessRestartLocal(int codeAddress, int length, int registerNum, StringIdItem name, TypeIdItem type, StringIdItem signature) {
                methodItems.add(new LocalDebugMethodItem(codeItem, codeAddress, MethodDefinition.this.stg, "RestartLocal", -1.0, registerNum, name, type, signature));
            }

            public void ProcessSetPrologueEnd(int codeAddress) {
                methodItems.add(new DebugMethodItem(codeAddress, MethodDefinition.this.stg, "EndPrologue", -4.0));
            }

            public void ProcessSetEpilogueBegin(int codeAddress) {
                methodItems.add(new DebugMethodItem(codeAddress, MethodDefinition.this.stg, "StartEpilogue", -4.0));
            }

            public void ProcessSetFile(int codeAddress, int length, final StringIdItem name) {
                methodItems.add(new DebugMethodItem(codeAddress, MethodDefinition.this.stg, "SetFile", -3.0){

                    protected void setAttributes(StringTemplate template) {
                        template.setAttribute("FileName", name.getStringValue());
                    }
                });
            }

            public void ProcessLineEmit(int codeAddress, final int line) {
                methodItems.add(new DebugMethodItem(codeAddress, MethodDefinition.this.stg, "Line", -2.0){

                    protected void setAttributes(StringTemplate template) {
                        template.setAttribute("Line", line);
                    }
                });
            }
        });
    }

    private void setLabelSequentialNumbers() {
        HashMap<String, Integer> nextLabelSequenceByType = new HashMap<String, Integer>();
        ArrayList<LabelMethodItem> sortedLabels = new ArrayList<LabelMethodItem>(this.labelCache.getLabels());
        Collections.sort(sortedLabels);
        for (LabelMethodItem labelMethodItem : sortedLabels) {
            Integer labelSequence = (Integer)nextLabelSequenceByType.get(labelMethodItem.getLabelPrefix());
            if (labelSequence == null) {
                labelSequence = 0;
            }
            labelMethodItem.setLabelSequence(labelSequence);
            nextLabelSequenceByType.put(labelMethodItem.getLabelPrefix(), labelSequence + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LabelCache {
        protected HashMap<LabelMethodItem, LabelMethodItem> labels = new HashMap();

        public LabelMethodItem internLabel(LabelMethodItem labelMethodItem) {
            LabelMethodItem internedLabelMethodItem = this.labels.get(labelMethodItem);
            if (internedLabelMethodItem != null) {
                if (!labelMethodItem.isCommentedOut()) {
                    internedLabelMethodItem.setUncommented();
                }
                return internedLabelMethodItem;
            }
            this.labels.put(labelMethodItem, labelMethodItem);
            return labelMethodItem;
        }

        public Collection<LabelMethodItem> getLabels() {
            return this.labels.values();
        }
    }
}

