/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.dexlib.Code.Format.SparseSwitchDataPseudoInstruction;
import org.jf.dexlib.CodeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseSwitchMethodItem
extends InstructionMethodItem<SparseSwitchDataPseudoInstruction>
implements Iterable<LabelMethodItem> {
    private final List<SparseSwitchTarget> targets;
    private final boolean dead;

    public SparseSwitchMethodItem(MethodDefinition methodDefinition, CodeItem codeItem, int codeAddress, boolean dead, StringTemplateGroup stg, SparseSwitchDataPseudoInstruction instruction) {
        super(codeItem, codeAddress, stg, instruction);
        int baseCodeAddress = methodDefinition.getSparseSwitchBaseAddress(codeAddress);
        this.targets = new ArrayList<SparseSwitchTarget>();
        Iterator<SparseSwitchDataPseudoInstruction.SparseSwitchTarget> iterator = instruction.iterateKeysAndTargets();
        while (iterator.hasNext()) {
            SparseSwitchDataPseudoInstruction.SparseSwitchTarget target = iterator.next();
            SparseSwitchTarget sparseSwitchTarget = new SparseSwitchTarget();
            sparseSwitchTarget.Key = target.key;
            LabelMethodItem label = new LabelMethodItem(baseCodeAddress + target.targetAddressOffset, stg, "sswitch_");
            sparseSwitchTarget.Target = label = methodDefinition.getLabelCache().internLabel(label);
            label.setUncommented();
            this.targets.add(sparseSwitchTarget);
        }
        this.dead = dead;
    }

    @Override
    protected void setAttributes(StringTemplate template) {
        template.setAttribute("Targets", this.targets);
        template.setAttribute("Dead", this.dead);
    }

    @Override
    public Iterator<LabelMethodItem> iterator() {
        return new Iterator<LabelMethodItem>(){
            private Iterator<SparseSwitchTarget> iterator;
            {
                this.iterator = SparseSwitchMethodItem.this.targets.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public LabelMethodItem next() {
                return this.iterator.next().Target;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    private static class SparseSwitchTarget {
        public int Key;
        public LabelMethodItem Target;

        private SparseSwitchTarget() {
        }
    }
}

