/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.Reference.Reference;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.OdexedFieldAccess;
import org.jf.dexlib.Code.OdexedInvokeVirtual;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.CodeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionMethodItem<T extends Instruction>
extends MethodItem {
    protected final CodeItem codeItem;
    protected final StringTemplateGroup stg;
    protected final T instruction;

    public InstructionMethodItem(CodeItem codeItem, int codeAddress, StringTemplateGroup stg, T instruction) {
        super(codeAddress);
        this.codeItem = codeItem;
        this.stg = stg;
        this.instruction = instruction;
    }

    @Override
    public double getSortOrder() {
        return 100.0;
    }

    protected String formatRegister(int register) {
        return RegisterFormatter.formatRegister(this.codeItem, register);
    }

    public String toString() {
        StringTemplate template = this.stg.getInstanceOf(((Instruction)this.instruction).getFormat().name());
        template.setAttribute("Opcode", ((Instruction)this.instruction).opcode.name);
        this.setAttributes(template);
        return template.toString();
    }

    protected void setAttributes(StringTemplate template) {
        if (this.instruction instanceof LiteralInstruction) {
            this.setLiteralAttributes((LiteralInstruction)this.instruction, template);
        }
        if (this.instruction instanceof SingleRegisterInstruction) {
            this.setSingleRegisterAttributes((SingleRegisterInstruction)this.instruction, template);
        }
        if (this.instruction instanceof FiveRegisterInstruction) {
            this.setFiveRegisterAttributes((FiveRegisterInstruction)this.instruction, template);
        }
        if (this.instruction instanceof RegisterRangeInstruction) {
            this.setRegisterRangeAttributes((RegisterRangeInstruction)this.instruction, template);
        }
        if (this.instruction instanceof InstructionWithReference) {
            this.setInstructionWithReferenceAttributes((InstructionWithReference)this.instruction, template);
        }
        if (this.instruction instanceof OdexedInvokeVirtual) {
            this.setOdexedInvokeVirtualAttributes((OdexedInvokeVirtual)this.instruction, template);
        }
        if (this.instruction instanceof OdexedFieldAccess) {
            this.setOdexedFieldAccessAttributes((OdexedFieldAccess)this.instruction, template);
        }
    }

    private void setLiteralAttributes(LiteralInstruction instruction, StringTemplate template) {
        long literal = instruction.getLiteral();
        if (literal <= Integer.MAX_VALUE && literal >= Integer.MIN_VALUE) {
            template.setAttribute("Literal", (int)literal);
        } else {
            template.setAttribute("Literal", literal);
        }
    }

    private void setSingleRegisterAttributes(SingleRegisterInstruction instruction, StringTemplate template) {
        template.setAttribute("RegisterA", this.formatRegister(instruction.getRegisterA()));
        if (instruction instanceof TwoRegisterInstruction) {
            this.setTwoRegisterAttributes((TwoRegisterInstruction)instruction, template);
        }
    }

    private void setTwoRegisterAttributes(TwoRegisterInstruction instruction, StringTemplate template) {
        template.setAttribute("RegisterB", this.formatRegister(instruction.getRegisterB()));
        if (instruction instanceof ThreeRegisterInstruction) {
            this.setThreeRegisterAttributes((ThreeRegisterInstruction)instruction, template);
        }
    }

    private void setThreeRegisterAttributes(ThreeRegisterInstruction instruction, StringTemplate template) {
        template.setAttribute("RegisterC", this.formatRegister(instruction.getRegisterC()));
    }

    private void setFiveRegisterAttributes(FiveRegisterInstruction instruction, StringTemplate template) {
        switch (instruction.getRegCount()) {
            case 1: {
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterD()));
                return;
            }
            case 2: {
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterD()));
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterE()));
                return;
            }
            case 3: {
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterD()));
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterE()));
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterF()));
                return;
            }
            case 4: {
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterD()));
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterE()));
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterF()));
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterG()));
                return;
            }
            case 5: {
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterD()));
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterE()));
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterF()));
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterG()));
                template.setAttribute("Registers", this.formatRegister(instruction.getRegisterA()));
            }
        }
    }

    private void setRegisterRangeAttributes(RegisterRangeInstruction instruction, StringTemplate template) {
        String[] registers = RegisterFormatter.formatFormat3rcRegisters(this.codeItem, instruction.getStartRegister(), instruction.getStartRegister() + instruction.getRegCount() - 1);
        template.setAttribute("StartRegister", registers[0]);
        template.setAttribute("LastRegister", registers[1]);
    }

    private void setInstructionWithReferenceAttributes(InstructionWithReference instruction, StringTemplate template) {
        template.setAttribute("Reference", Reference.createReference(template.getGroup(), instruction.getReferencedItem()));
    }

    private void setOdexedInvokeVirtualAttributes(OdexedInvokeVirtual instruction, StringTemplate template) {
        template.setAttribute("MethodIndex", instruction.getMethodIndex());
    }

    private void setOdexedFieldAccessAttributes(OdexedFieldAccess instruction, StringTemplate template) {
        template.setAttribute("FieldOffset", instruction.getFieldOffset());
    }
}

