/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.EncodedValue;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.EncodedValue.AnnotationEncodedValueAdaptor;
import org.jf.baksmali.Adaptors.EncodedValue.ArrayEncodedValueAdaptor;
import org.jf.baksmali.Adaptors.EncodedValue.EncodedIndexedItemAdaptor;
import org.jf.baksmali.Adaptors.EncodedValue.EnumEncodedValueAdaptor;
import org.jf.baksmali.Adaptors.EncodedValue.SimpleEncodedValueAdaptor;
import org.jf.baksmali.Adaptors.Reference.FieldReference;
import org.jf.baksmali.Adaptors.Reference.MethodReference;
import org.jf.baksmali.Adaptors.Reference.StringReference;
import org.jf.baksmali.Adaptors.Reference.TypeReference;
import org.jf.dexlib.EncodedValue.AnnotationEncodedValue;
import org.jf.dexlib.EncodedValue.ArrayEncodedValue;
import org.jf.dexlib.EncodedValue.BooleanEncodedValue;
import org.jf.dexlib.EncodedValue.ByteEncodedValue;
import org.jf.dexlib.EncodedValue.CharEncodedValue;
import org.jf.dexlib.EncodedValue.DoubleEncodedValue;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.EnumEncodedValue;
import org.jf.dexlib.EncodedValue.FieldEncodedValue;
import org.jf.dexlib.EncodedValue.FloatEncodedValue;
import org.jf.dexlib.EncodedValue.IntEncodedValue;
import org.jf.dexlib.EncodedValue.LongEncodedValue;
import org.jf.dexlib.EncodedValue.MethodEncodedValue;
import org.jf.dexlib.EncodedValue.ShortEncodedValue;
import org.jf.dexlib.EncodedValue.StringEncodedValue;
import org.jf.dexlib.EncodedValue.TypeEncodedValue;

public abstract class EncodedValueAdaptor {
    public static StringTemplate create(StringTemplateGroup stg, EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case VALUE_ANNOTATION: {
                return AnnotationEncodedValueAdaptor.createTemplate(stg, (AnnotationEncodedValue)encodedValue);
            }
            case VALUE_ARRAY: {
                return ArrayEncodedValueAdaptor.createTemplate(stg, (ArrayEncodedValue)encodedValue);
            }
            case VALUE_BOOLEAN: {
                return SimpleEncodedValueAdaptor.createTemplate(stg, ((BooleanEncodedValue)encodedValue).value);
            }
            case VALUE_BYTE: {
                return SimpleEncodedValueAdaptor.createTemplate(stg, ((ByteEncodedValue)encodedValue).value);
            }
            case VALUE_CHAR: {
                return SimpleEncodedValueAdaptor.createTemplate(stg, Character.valueOf(((CharEncodedValue)encodedValue).value));
            }
            case VALUE_DOUBLE: {
                return SimpleEncodedValueAdaptor.createTemplate(stg, ((DoubleEncodedValue)encodedValue).value);
            }
            case VALUE_ENUM: {
                return EnumEncodedValueAdaptor.createTemplate(stg, FieldReference.createTemplate(stg, ((EnumEncodedValue)encodedValue).value));
            }
            case VALUE_FIELD: {
                return EncodedIndexedItemAdaptor.createTemplate(stg, FieldReference.createTemplate(stg, ((FieldEncodedValue)encodedValue).value));
            }
            case VALUE_FLOAT: {
                return SimpleEncodedValueAdaptor.createTemplate(stg, Float.valueOf(((FloatEncodedValue)encodedValue).value));
            }
            case VALUE_INT: {
                return SimpleEncodedValueAdaptor.createTemplate(stg, ((IntEncodedValue)encodedValue).value);
            }
            case VALUE_LONG: {
                return SimpleEncodedValueAdaptor.createTemplate(stg, ((LongEncodedValue)encodedValue).value);
            }
            case VALUE_METHOD: {
                return EncodedIndexedItemAdaptor.createTemplate(stg, MethodReference.createTemplate(stg, ((MethodEncodedValue)encodedValue).value));
            }
            case VALUE_NULL: {
                return SimpleEncodedValueAdaptor.createTemplate(stg, "null");
            }
            case VALUE_SHORT: {
                return SimpleEncodedValueAdaptor.createTemplate(stg, ((ShortEncodedValue)encodedValue).value);
            }
            case VALUE_STRING: {
                return EncodedIndexedItemAdaptor.createTemplate(stg, StringReference.createTemplate(stg, ((StringEncodedValue)encodedValue).value));
            }
            case VALUE_TYPE: {
                return EncodedIndexedItemAdaptor.createTemplate(stg, TypeReference.createTemplate(stg, ((TypeEncodedValue)encodedValue).value));
            }
        }
        return null;
    }
}

