/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplateWriter;

public class AutoIndentWriter
implements StringTemplateWriter {
    protected List indents = new ArrayList();
    protected int[] anchors = new int[10];
    protected int anchors_sp = -1;
    protected String newline;
    protected Writer out = null;
    protected boolean atStartOfLine = true;
    protected int charPosition = 0;
    protected int lineWidth = -1;
    protected int charPositionOfStartOfExpr = 0;

    public AutoIndentWriter(Writer writer, String string) {
        this.out = writer;
        this.indents.add(null);
        this.newline = string;
    }

    public AutoIndentWriter(Writer writer) {
        this(writer, System.getProperty("line.separator"));
    }

    public void setLineWidth(int n2) {
        this.lineWidth = n2;
    }

    public void pushIndentation(String string) {
        this.indents.add(string);
    }

    public String popIndentation() {
        return (String)this.indents.remove(this.indents.size() - 1);
    }

    public void pushAnchorPoint() {
        if (this.anchors_sp + 1 >= this.anchors.length) {
            int[] nArray = new int[this.anchors.length * 2];
            System.arraycopy(this.anchors, 0, nArray, 0, this.anchors.length - 1);
            this.anchors = nArray;
        }
        ++this.anchors_sp;
        this.anchors[this.anchors_sp] = this.charPosition;
    }

    public void popAnchorPoint() {
        --this.anchors_sp;
    }

    public int getIndentationWidth() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.indents.size(); ++i2) {
            String string = (String)this.indents.get(i2);
            if (string == null) continue;
            n2 += string.length();
        }
        return n2;
    }

    public int write(String string) throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\r' || c2 == '\n') {
                this.atStartOfLine = true;
                this.charPosition = -1;
                this.out.write(this.newline);
                this.charPosition += (n2 += this.newline.length());
                if (c2 != '\r' || i2 + 1 >= string.length() || string.charAt(i2 + 1) != '\n') continue;
                ++i2;
                continue;
            }
            if (this.atStartOfLine) {
                n2 += this.indent();
                this.atStartOfLine = false;
            }
            ++n2;
            this.out.write(c2);
            ++this.charPosition;
        }
        return n2;
    }

    public int writeSeparator(String string) throws IOException {
        return this.write(string);
    }

    public int write(String string, String string2) throws IOException {
        int n2 = this.writeWrapSeparator(string2);
        return n2 + this.write(string);
    }

    public int writeWrapSeparator(String string) throws IOException {
        int n2 = 0;
        if (this.lineWidth != -1 && string != null && !this.atStartOfLine && this.charPosition >= this.lineWidth) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '\n') {
                    ++n2;
                    this.out.write(c2);
                    this.charPosition = 0;
                    int n3 = this.getIndentationWidth();
                    int n4 = 0;
                    if (this.anchors_sp >= 0) {
                        n4 = this.anchors[this.anchors_sp];
                    }
                    if (n4 > n3) {
                        n2 += this.indent(n4);
                        continue;
                    }
                    n2 += this.indent();
                    continue;
                }
                ++n2;
                this.out.write(c2);
                ++this.charPosition;
            }
        }
        return n2;
    }

    public int indent() throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < this.indents.size(); ++i2) {
            String string = (String)this.indents.get(i2);
            if (string == null) continue;
            n2 += string.length();
            this.out.write(string);
        }
        this.charPosition += n2;
        return n2;
    }

    public int indent(int n2) throws IOException {
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.out.write(32);
        }
        this.charPosition += n2;
        return n2;
    }
}

