/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastQueue<T> {
    protected List<T> data = new ArrayList<T>();
    protected int p = 0;

    public void reset() {
        this.p = 0;
        this.data.clear();
    }

    public T remove() {
        T o2 = this.get(0);
        ++this.p;
        if (this.p == this.data.size()) {
            this.clear();
        }
        return o2;
    }

    public void add(T o2) {
        this.data.add(o2);
    }

    public int size() {
        return this.data.size() - this.p;
    }

    public T head() {
        return this.get(0);
    }

    public T get(int i2) {
        if (this.p + i2 >= this.data.size()) {
            throw new NoSuchElementException("queue index " + (this.p + i2) + " > size " + this.data.size());
        }
        return this.data.get(this.p + i2);
    }

    public void clear() {
        this.p = 0;
        this.data.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            buf.append(this.get(i2));
            if (i2 + 1 >= n2) continue;
            buf.append(" ");
        }
        return buf.toString();
    }
}

