/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.ucf.ISigner;
import com.adobe.ucf.UCFOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Packager
implements ISigner {
    private static final char[] PROHIBITED_FILENAME_CHARACTERS = new char[]{'\\', ':', '*', '?', '\"', '<', '>', '|'};
    private SortedMap<String, File> m_sources = new TreeMap<String, File>(String.CASE_INSENSITIVE_ORDER);
    private File m_output;
    private File m_tempFile;
    private UCFOutputStream m_stream;

    @Override
    public void setOutput(File output) throws FileNotFoundException, IOException {
        if (this.m_output != null) {
            throw new IllegalStateException("output already set");
        }
        if (output.exists() && !output.canWrite()) {
            throw new IOException("cannot overwrite an existing, read-only file");
        }
        this.m_output = output;
    }

    @Override
    public void setPrivateKey(PrivateKey key) {
        this.m_stream.setPrivateKey(key);
    }

    @Override
    public void setAlsoIncludeOldStyleTimestamp() {
        this.m_stream.setAlsoIncludeOldStyleTimestamp();
    }

    @Override
    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        this.m_stream.setCertificateChain(certchain);
    }

    @Override
    public void setSignerCertificate(Certificate cert) throws CertificateException {
        this.m_stream.setSignerCertificate(cert);
    }

    @Override
    public void setTimestampURL(String url) {
        this.m_stream.setTimestampURL(url);
    }

    public void addSourceWithRoot(File source, File root) {
        this.addSourceWithPath(source, root.toURI().relativize(source.toURI()).getPath());
    }

    public void addSourceWithPath(File source, String path) {
        if (!source.isFile()) {
            throw new IllegalArgumentException("File does not exist: " + source.getPath());
        }
        if (source.getName().matches("^\\s.*")) {
            throw new IllegalArgumentException("Filename contains leading whitespace");
        }
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("absolute path");
        }
        for (char c2 : PROHIBITED_FILENAME_CHARACTERS) {
            if (!path.contains(new Character(c2).toString())) continue;
            throw new IllegalArgumentException("Filename contains restricted character '" + c2 + "'");
        }
        for (char lowAscii = '\u0000'; lowAscii <= '\u001f'; lowAscii = (char)(lowAscii + '\u0001')) {
            if (!path.contains(new Character(lowAscii).toString())) continue;
            throw new IllegalArgumentException("Filename contains restricted low-ascii character " + lowAscii);
        }
        if (path.toUpperCase().startsWith("META-INF/")) {
            throw new IllegalArgumentException("Paths beginning with META-INF/ are reserved");
        }
        if (this.m_sources.containsKey(path)) {
            File other = (File)this.m_sources.get(path);
            throw new IllegalArgumentException("Files \"" + other.getPath() + "\" and \"" + source.getPath() + "\" have conflicting package paths");
        }
        this.m_sources.put(path, source);
    }

    public void close() {
        try {
            if (this.m_stream != null) {
                this.m_stream.close();
            }
            this.m_tempFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initTempFile(String prefix) throws IOException {
        this.m_tempFile = File.createTempFile(prefix, null, this.m_output.getAbsoluteFile().getParentFile());
        this.getStream().setOutput(this.m_tempFile);
    }

    protected void initTempFolder(String prefix) throws IOException {
        this.m_tempFile = File.createTempFile(prefix, null, this.m_output.getAbsoluteFile().getParentFile());
        this.m_tempFile.delete();
        this.m_tempFile.mkdir();
    }

    protected void renameOutput() throws IOException {
        boolean deleteSucceeded;
        if (this.m_output.exists() && !(deleteSucceeded = this.m_output.delete())) {
            throw new IOException("Unable to create output file: " + this.m_output.getPath());
        }
        boolean renameSucceeded = this.m_tempFile.renameTo(this.m_output);
        if (!renameSucceeded) {
            throw new IOException("Unable to create output file: " + this.m_output.getPath());
        }
    }

    protected void setSources(SortedMap<String, File> sources) {
        this.m_sources = sources;
    }

    protected SortedMap<String, File> getSources() {
        return this.m_sources;
    }

    protected UCFOutputStream getStream() {
        return this.m_stream;
    }

    protected void setStream(UCFOutputStream stream) {
        this.m_stream = stream;
    }

    protected File getOutput() {
        return this.m_output;
    }

    protected File getTempFile() {
        return this.m_tempFile;
    }
}

