/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.png;

import com.adobe.png.PNGChunk;
import com.adobe.png.PNGReader;
import com.adobe.png.PNGTextChunk;
import com.adobe.png.PNGWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PNGUtils {
    public static InputStream updatePNGMetadata(InputStream inputStream, String keyword, String prefix, String rest) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((len = inputStream.read(data)) >= 0) {
            out.write(data, 0, len);
        }
        inputStream.close();
        data = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            PNGChunk chunk;
            out.reset();
            PNGWriter writer = new PNGWriter(out);
            PNGReader reader = new PNGReader(in);
            boolean insertedMetadata = false;
            while ((chunk = reader.readChunk()) != null) {
                if (chunk.typeStr == "tEXt") {
                    PNGTextChunk textChunk = new PNGTextChunk(chunk);
                    if (textChunk.keyword == keyword && prefix != null && textChunk.value.startsWith(prefix)) continue;
                }
                if (!(insertedMetadata || chunk.typeStr != "IDAT" && chunk.typeStr != "IEND")) {
                    String metadata = (prefix == null ? "" : prefix) + rest;
                    writer.writeChunk(new PNGTextChunk(keyword, metadata));
                    insertedMetadata = true;
                }
                writer.writeChunk(chunk);
            }
            if (!insertedMetadata) {
                throw new PNGReader.ParseException("missing chunks");
            }
            data = out.toByteArray();
        }
        catch (PNGReader.ParseException e2) {
            // empty catch block
        }
        return new ByteArrayInputStream(data);
    }
}

