/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static void consumeOutput(Process process) {
        new OutputEater(process.getInputStream()).run();
        new OutputEater(process.getErrorStream()).run();
    }

    public static File getSDKLibDir() throws IOException {
        try {
            return Utils.getJarFile().getParentFile();
        }
        catch (Exception e2) {
            throw new IOException("failed to get jar directory");
        }
    }

    public static File getJarFile() throws IOException {
        try {
            return new File(new Utils().getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e2) {
            throw new IOException("failed to find jar file");
        }
    }

    public static void copyTo(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            dest.mkdirs();
            for (File sourceChild : source.listFiles()) {
                File destChild = new File(dest, sourceChild.getName());
                Utils.copyTo(sourceChild, destChild);
            }
        } else {
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(dest);
            Utils.copyTo(in, out);
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static void copyTo(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
    }

    public static boolean deleteAll(File file) {
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                if (Utils.deleteAll(child)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static byte[] readIn(InputStream in) throws IOException {
        byte[] data = new byte[in.available()];
        in.read(data);
        return data;
    }

    public static void writeOut(InputStream in, File f2) throws IOException {
        FileOutputStream out = new FileOutputStream(f2);
        byte[] data = new byte[4096];
        while (in.read(data) > 0) {
            ((OutputStream)out).write(data);
        }
        ((OutputStream)out).close();
    }

    public static File getFileWithExtension(String outputFilename, String extension) {
        File outputFile = new File(outputFilename);
        String name = outputFile.getName();
        if (!name.matches(".+\\.[^\\.]+")) {
            name = name + extension;
        }
        return new File(outputFile.getParentFile(), name);
    }

    public static Process execSafely(File directory, String ... args) throws IOException {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            return Utils.execSafelyWin(directory, args);
        }
        return Utils.execSafelyUnix(directory, args);
    }

    private static Process execSafelyUnix(File directory, String ... args) throws IOException {
        File cmdFile = File.createTempFile("cmd", null);
        cmdFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(cmdFile);
        if (directory != null) {
            out.write(("cd " + Utils.quote(directory.getPath()) + "\n").getBytes("UTF-8"));
        }
        for (String arg : args) {
            out.write((Utils.quote(arg) + " ").getBytes("UTF-8"));
        }
        out.close();
        return new ProcessBuilder("/bin/sh", cmdFile.getAbsolutePath()).start();
    }

    private static Process execSafelyWin(File directory, String ... args) throws IOException {
        String varNameBase = "ADT_ENV_VAR_";
        ProcessBuilder builder = new ProcessBuilder("cmd", "/c");
        if (directory != null) {
            builder.directory(directory);
        }
        int count = 0;
        for (String arg : args) {
            String varName = "ADT_ENV_VAR_" + count;
            builder.command().add("%" + varName + "%");
            builder.environment().put(varName, "\"" + arg + "\"");
            ++count;
        }
        return builder.start();
    }

    public static Process execSafely(File directory, List<String> args) throws IOException {
        return Utils.execSafely(directory, args.toArray(new String[0]));
    }

    private static String quote(String string) {
        return "\"" + string.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\\\"") + "\"";
    }

    protected static String getRelativePath(File source, File root) {
        return root.toURI().relativize(source.toURI()).getPath();
    }

    public static String performPlatformUnicodePathNormalization(String path) {
        File temp = null;
        try {
            temp = File.createTempFile("temp", null);
            String string = Utils.getRelativePath(new File(temp, path).getCanonicalFile(), temp.getCanonicalFile());
            return string;
        }
        catch (IOException e2) {
            throw new IllegalStateException("couldn't cannonicalize path");
        }
        finally {
            if (temp != null && temp.exists()) {
                temp.delete();
            }
        }
    }

    public static class OutputEater
    extends Thread {
        private InputStream _in;
        private OutputStream _out;

        public OutputEater(InputStream in, OutputStream out) {
            this._in = in;
            this._out = out;
        }

        public OutputEater(InputStream in) {
            this(in, null);
        }

        public void run() {
            try {
                int len;
                byte[] buffer = new byte[4096];
                while ((len = this._in.read(buffer)) != -1) {
                    if (this._out == null) continue;
                    this._out.write(buffer, 0, len);
                    this._out.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

