/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTPackager;
import com.adobe.air.AIROutputStream;
import com.adobe.air.Descriptor;
import com.adobe.air.validator.ApplicationDescriptorValidationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public final class AIRPackager
extends ADTPackager {
    private static String Adobe_patent_P817 = "AdobePatentId=\"P817\"";
    private boolean m_nativeMode = false;

    public AIRPackager() {
        this.setStream(new AIROutputStream());
    }

    public void setPrivateKey(PrivateKey key) {
        super.setPrivateKey(key);
        this.setTimestampURL("https://timestamp.geotrust.com/tsa");
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        if (certchain == null || certchain.length == 0) {
            throw new IllegalArgumentException("empty certificate chain");
        }
        super.setCertificateChain(certchain);
        String CODE_SIGNING_OID = "1.3.6.1.5.5.7.3.3";
        List<String> extendedKeyUsage = ((X509Certificate)certchain[0]).getExtendedKeyUsage();
        if (extendedKeyUsage == null || !extendedKeyUsage.contains("1.3.6.1.5.5.7.3.3")) {
            throw new CertificateException("not a code signing certificate");
        }
    }

    public void setDescriptor(File descriptorFile) {
        if (this.m_airiFile != null) {
            throw new IllegalStateException(".airi input already set");
        }
        super.setDescriptor(descriptorFile);
    }

    public void createIntermediate() throws IOException {
        this.m_sign = false;
        try {
            this.createPackage();
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("certificate exception with signing disabled");
        }
    }

    public void createAIR() throws GeneralSecurityException, IOException {
        this.createPackage();
    }

    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("air");
    }

    public File getIntermediate() {
        return this.m_airiFile;
    }

    protected void validateDescriptor() throws ApplicationDescriptorValidationException {
        try {
            this.m_descriptor = new Descriptor(this.m_descriptorFile, this.m_validate);
            if (this.m_validate) {
                if (this.m_nativeMode) {
                    this.getDescriptor().validateForNativePackaging(this.getSources());
                } else if (this.m_sign) {
                    this.getDescriptor().validateForAIRPackaging(this.getSources());
                } else {
                    this.getDescriptor().validateForAIRIPackaging(this.getSources());
                }
            }
        }
        catch (ApplicationDescriptorValidationException e2) {
            if (this.m_listener != null) {
                this.m_listener.message(e2.getFirstMessage());
            }
            throw e2;
        }
    }

    protected void addSpecialFiles() throws IOException {
        this.getStream().addMimeTypeFile(this.m_sign ? "application/vnd.adobe.air-application-installer-package+zip" : "application/vnd.adobe.air-application-intermediate-package+zip", this.m_sign);
        super.addSpecialFiles();
        this.getStream().addHashFile("META-INF/AIR/hash");
        if (this.m_debug) {
            this.getStream().addDebugFile("META-INF/AIR/debug", this.m_sign);
        }
    }

    public void setNativeMode(boolean nativeMode) {
        this.m_nativeMode = nativeMode;
        this.getStream().setNativeMode(nativeMode);
    }

    public void setAIRFile(File airFile) {
        throw new IllegalStateException("Tried to set an air file as input on an AIRPackager");
    }

    protected AIROutputStream getStream() {
        return (AIROutputStream)super.getStream();
    }

    public void validate() {
        block2: {
            try {
                new Descriptor(this.m_descriptorFile).validateForAIRPackaging(this.getSources());
            }
            catch (ApplicationDescriptorValidationException e2) {
                if (this.m_listener == null) break block2;
                this.m_listener.message(e2.getFirstMessage());
            }
        }
    }
}

