/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.util;

import com.adobe.pdfservices.operation.internal.GlobalConfig;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathUtil.class);

    private static void createTempDirectoryIfRequired() {
        File file = new File(PathUtil.getTemporaryDirectoryPath());
        if (!file.exists()) {
            file.mkdir();
        } else {
            LOGGER.debug("Temporary directory already exists. Won't be created again");
        }
    }

    public static String getTemporaryDirectoryPath() {
        String systemTemporaryDirectory = GlobalConfig.getSystemTemporaryDirectory();
        if (systemTemporaryDirectory.endsWith(File.separator)) {
            return String.format("%s%s", systemTemporaryDirectory, GlobalConfig.getTemporaryOperationResultDirectory());
        }
        return String.format("%s%s%s", systemTemporaryDirectory, File.separator, GlobalConfig.getTemporaryOperationResultDirectory());
    }

    public static String getTemporaryDestinationPath(String sourceName, String targetExtension) {
        String destinationFileName = StringUtil.isBlank(sourceName) ? FileUtil.getRandomFileName(targetExtension) : PathUtil.getFileNameWithExtension(PathUtil.getBaseName(sourceName), targetExtension);
        PathUtil.createTempDirectoryIfRequired();
        return String.format("%s%s%s", PathUtil.getTemporaryDirectoryPath(), File.separator, destinationFileName);
    }

    public static String getFileNameWithExtension(String baseName, String targetExtension) {
        if (targetExtension == null) {
            return baseName;
        }
        if (targetExtension.startsWith(".")) {
            return baseName + targetExtension;
        }
        return baseName + "." + targetExtension;
    }

    public static String getExtension(String filePath) {
        return FilenameUtils.getExtension((String)filePath);
    }

    public static String getFileName(String filePath) {
        if (StringUtil.isNotBlank(filePath)) {
            return FilenameUtils.getName((String)filePath);
        }
        return "";
    }

    public static String getBaseName(String filePath) {
        if (StringUtil.isNotBlank(filePath)) {
            return FilenameUtils.getBaseName((String)filePath);
        }
        return "";
    }

    public static String getFullPath(String filePath) {
        if (StringUtil.isNotBlank(filePath)) {
            return FilenameUtils.getFullPath((String)filePath);
        }
        return "";
    }

    public static String getSubPath(String directory, String subDirectory) {
        if (StringUtil.isNotBlank(directory) && StringUtil.isNotBlank(subDirectory)) {
            return directory + File.separator + subDirectory;
        }
        return "";
    }
}

