/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.documentmerge.DocumentMergeParams;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.documentmerge.DocumentMergeOptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class DocumentMergeService {
    private static final String INPUT_FORMAT_SPECIFIER = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";

    public static String mergeDocument(InternalExecutionContext context, FileRefImpl sourceFileRef, DocumentMergeOptions documentMergeOptions, String operation) throws FileNotFoundException, JsonProcessingException {
        DocumentMergeParams documentMergeParams = new DocumentMergeParams(documentMergeOptions.getOutputFormat().getFormat(), documentMergeOptions.getJsonDataForMerge(), documentMergeOptions.getFragments());
        Inputs inputs = Inputs.builder(INPUT_FORMAT_SPECIFIER).setParams(documentMergeParams).build();
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-52d5db6097ed436ebb96f13a4c7bf8fb", inputs, ExtensionMediaTypeMapping.getFromExtension(documentMergeOptions.getOutputFormat().toString()).getMediaType());
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }
}

