/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.DeletePagesParams;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class DeletePagesService {
    private static final String OUTPUT_FORMAT_SPECIFIER = "application/pdf";

    public static String deletePages(InternalExecutionContext context, FileRefImpl sourceFileRef, PageRanges pageRanges, String operation) throws FileNotFoundException {
        DeletePagesParams deletePagesParams = DeletePagesParams.createFrom(pageRanges);
        Inputs inputs = Inputs.builder(OUTPUT_FORMAT_SPECIFIER).setParams(deletePagesParams).build();
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-4735fcf3cf924b25879e6fcf7aa84ad4", inputs, OUTPUT_FORMAT_SPECIFIER);
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }
}

