/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.http;

import com.adobe.pdfservices.operation.internal.GlobalConfig;
import com.adobe.pdfservices.operation.internal.http.HttpClient;
import com.adobe.pdfservices.operation.internal.http.HttpClientType;
import com.adobe.pdfservices.operation.internal.http.HttpClientWrapper;
import com.adobe.pdfservices.operation.internal.http.config.HttpClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientFactory.class);
    private static HttpClient httpClient;

    private static void initialiseDcHttpClient(HttpClientConfig httpClientConfig) {
        HttpClientType type;
        if (httpClient == null && (type = httpClientConfig.getClientType()) == HttpClientType.APACHE) {
            httpClient = new HttpClientWrapper(httpClientConfig);
        }
    }

    public static HttpClient getDefaultHttpClient() {
        if (httpClient == null) {
            LOGGER.debug("Initializing http client on basis of Client config ");
            HttpClientConfig httpClientConfig = new HttpClientConfig.Builder().clientType(HttpClientType.APACHE).withConnectTimeout(GlobalConfig.getConnectTimeout()).withSocketTimeout(GlobalConfig.getSocketTimeout()).build();
            HttpClientFactory.initialiseDcHttpClient(httpClientConfig);
        }
        return httpClient;
    }
}

