/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.http;

import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class BaseHttpResponse<T>
implements HttpResponse<T> {
    private int statusCode;
    private Map<String, String> headers;
    private T baseResponseDto;
    private List<InputStream> inputStreamList;

    public BaseHttpResponse(int statusCode, Map<String, String> headers, T baseResponseDto) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.baseResponseDto = baseResponseDto;
    }

    public BaseHttpResponse(int statusCode, Map<String, String> headers) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.inputStreamList = null;
        this.baseResponseDto = null;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getRequestId() {
        if (this.headers != null) {
            return this.headers.get("x-request-id");
        }
        return null;
    }

    @Override
    public T getBody() {
        return this.baseResponseDto;
    }

    @Override
    public List<InputStream> getResponseAsStreamList() {
        return this.inputStreamList;
    }

    @Override
    public void consume() throws IOException {
        for (InputStream inputStream : this.inputStreamList) {
            if (inputStream == null) continue;
            inputStream.close();
        }
    }
}

