/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.auth;

import com.adobe.pdfservices.operation.auth.ServiceAccountCredentials;
import com.adobe.pdfservices.operation.exception.SdkException;
import com.adobe.pdfservices.operation.internal.GlobalConfig;
import com.adobe.pdfservices.operation.internal.auth.AuthenticationMethod;
import com.adobe.pdfservices.operation.internal.auth.Authenticator;
import com.adobe.pdfservices.operation.internal.auth.ServiceAccountCredentialsWithUri;
import com.adobe.pdfservices.operation.internal.auth.SessionToken;
import com.adobe.pdfservices.operation.internal.cpf.constants.RequestKey;
import com.adobe.pdfservices.operation.internal.dto.response.AuthenticationResponseDto;
import com.adobe.pdfservices.operation.internal.http.BaseHttpRequest;
import com.adobe.pdfservices.operation.internal.http.HttpClient;
import com.adobe.pdfservices.operation.internal.http.HttpClientFactory;
import com.adobe.pdfservices.operation.internal.http.HttpMethod;
import com.adobe.pdfservices.operation.internal.http.HttpRequest;
import com.adobe.pdfservices.operation.internal.http.HttpRequestConfig;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.internal.util.PrivateKeyParser;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.PrivateKey;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthenticator
implements Authenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtAuthenticator.class);
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String JWT_TOKEN = "jwt_token";
    private static final int expiryMs = 86400000;
    private static String JWT_ENDPOINT;
    private static String JWT_AUDIENCE_BASE_URI;
    private ServiceAccountCredentials serviceAccountConfiguration;
    private SessionToken sessionToken;
    private PrivateKey privateKey;

    public JwtAuthenticator(ServiceAccountCredentials serviceAccountConfiguration) {
        this.serviceAccountConfiguration = serviceAccountConfiguration;
        this.privateKey = PrivateKeyParser.parsePrivateKey(serviceAccountConfiguration.getPrivateKey());
        JWT_ENDPOINT = String.format("%s/%s", ((ServiceAccountCredentialsWithUri)serviceAccountConfiguration).getImsBaseUri(), GlobalConfig.getJwtUriSuffix());
        JWT_AUDIENCE_BASE_URI = String.format("%s/%s", ((ServiceAccountCredentialsWithUri)serviceAccountConfiguration).getImsBaseUri(), GlobalConfig.getJwtAudienceSuffix());
    }

    @Override
    public String getClientId() {
        return this.serviceAccountConfiguration.getClientId();
    }

    @Override
    public synchronized SessionToken getSessionToken(HttpRequestConfig requestConfig) {
        if (this.sessionToken != null) {
            Duration durationTillSessionExpiry = Duration.between(Instant.now(), this.sessionToken.getExpiresAt());
            if (durationTillSessionExpiry.getSeconds() > 0L && durationTillSessionExpiry.toMinutes() > 2L) {
                LOGGER.debug("Session Token is valid, won't be refreshed. ");
                return this.sessionToken;
            }
            LOGGER.debug("Session token expired. Refreshing! ");
        }
        return this.refreshSessionToken(requestConfig);
    }

    @Override
    public synchronized SessionToken refreshSessionToken(HttpRequestConfig requestConfig) {
        HttpClient client = HttpClientFactory.getDefaultHttpClient();
        HttpRequest httpRequest = new BaseHttpRequest("ims.session_token", HttpMethod.POST, JWT_ENDPOINT).withAuthenticationMethod(AuthenticationMethod.UNAUTHENTICATED).withHeader("x-request-id", UUID.randomUUID().toString()).withHeader("x-api-app-info", GlobalConfig.getAppInfo()).withHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString()).withUrlEncodedFormParams(this.getFormParams()).withRequestKey(RequestKey.AUTHN).withConfig(requestConfig);
        HttpResponse<AuthenticationResponseDto> sessionTokenResponse = client.send(httpRequest, AuthenticationResponseDto.class);
        AuthenticationResponseDto authResponseBody = sessionTokenResponse.getBody();
        this.sessionToken = new SessionToken(authResponseBody.getAccessToken(), Instant.now().plusMillis(authResponseBody.getExpiryInterval()));
        return this.sessionToken;
    }

    private List<NameValuePair> getFormParams() {
        ArrayList<NameValuePair> formParams = new ArrayList<NameValuePair>();
        formParams.add((NameValuePair)new BasicNameValuePair(CLIENT_ID, this.serviceAccountConfiguration.getClientId()));
        formParams.add((NameValuePair)new BasicNameValuePair(CLIENT_SECRET, this.serviceAccountConfiguration.getClientSecret()));
        formParams.add((NameValuePair)new BasicNameValuePair(JWT_TOKEN, this.prepareJwt()));
        return formParams;
    }

    private String prepareJwt() {
        String audience = JWT_AUDIENCE_BASE_URI + this.serviceAccountConfiguration.getClientId();
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(this.serviceAccountConfiguration.getAccountId()).issuer(this.serviceAccountConfiguration.getOrganizationId()).audience(audience).expirationTime(new Date(System.currentTimeMillis() + 86400000L)).claim(((ServiceAccountCredentialsWithUri)this.serviceAccountConfiguration).getClaim(), (Object)true).build();
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).build(), claimsSet);
        RSASSASigner signer = new RSASSASigner(this.privateKey);
        try {
            signedJWT.sign((JWSSigner)signer);
        }
        catch (JOSEException e) {
            LOGGER.error("Exception encountered while signing JWT ", (Throwable)e);
            throw new SdkException("Exception while signing JWT", e);
        }
        return signedJWT.serialize();
    }
}

