/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.api;

import com.adobe.pdfservices.operation.exception.SdkException;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.internal.http.MultiPartHttpResponse;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.internet.MimeBodyPart;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDownloadApi.class);

    public static <T> void downloadAndSave(InternalExecutionContext context, String location, String destinationPath, Class<T> responseType) throws IOException {
        HttpResponse<T> response = CPFApi.cpfStatusApi(context, location, responseType);
        InputStream inputStream = !response.getResponseAsStreamList().isEmpty() ? response.getResponseAsStreamList().get(0) : null;
        File file = new File(destinationPath);
        try {
            LOGGER.info("Downloading file to {} ", (Object)destinationPath);
            Files.copy(inputStream, file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error {} while writing downloaded file to location {} ", (Object)e, (Object)destinationPath);
            throw new SdkException("Exception encountered while downloading file", e);
        }
        catch (NullPointerException e) {
            LOGGER.error("Error while fetching the output file content from the multipart response");
            throw new IOException("Exception encountered while downloading file", e);
        }
        finally {
            try {
                response.consume();
            }
            catch (IOException e) {
                LOGGER.error("Error while consuming file download response ", (Throwable)e);
            }
        }
    }

    public static <T> List<String> downloadAndSaveMultiple(InternalExecutionContext context, String location, String targetFileExtension, Class<T> responseType) throws IOException {
        HttpResponse<T> response = CPFApi.cpfStatusApi(context, location, responseType);
        List<InputStream> inputStreamList = response.getResponseAsStreamList();
        ArrayList<String> paths = new ArrayList<String>();
        String temporaryDestinationPath = null;
        try {
            if (inputStreamList.isEmpty()) {
                throw new NullPointerException();
            }
            for (InputStream inputStream : inputStreamList) {
                String targetFileName = FileUtil.getRandomFileName(targetFileExtension);
                temporaryDestinationPath = PathUtil.getTemporaryDestinationPath(targetFileName, targetFileName);
                File file = new File(temporaryDestinationPath);
                LOGGER.info("Downloading file to {} ", (Object)temporaryDestinationPath);
                Files.copy(inputStream, file.toPath(), new CopyOption[0]);
                paths.add(temporaryDestinationPath);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error {} while writing downloaded file to location {} ", (Object)e, temporaryDestinationPath);
            throw new SdkException("Exception encountered while downloading file", e);
        }
        catch (NullPointerException e) {
            LOGGER.error("Error while fetching the output file content from the multipart response");
            throw new IOException("Exception encountered while downloading file", e);
        }
        finally {
            try {
                response.consume();
            }
            catch (IOException e) {
                LOGGER.error("Error while consuming file download response ", (Throwable)e);
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadAndSaveJson(InternalExecutionContext context, String location, String destinationPath) {
        HttpResponse<CPFContentAnalyzerResponse> response = CPFApi.cpfStatusApi(context, location, CPFContentAnalyzerResponse.class);
        MultiPartHttpResponse multiPartData = (MultiPartHttpResponse)response;
        List<MimeBodyPart> responseData = multiPartData.getResponseBodyParts();
        try {
            InputStream inputStream = !response.getResponseAsStreamList().isEmpty() ? responseData.get(1).getInputStream() : null;
            File file = new File(destinationPath);
            LOGGER.info("Downloading file to {} ", (Object)destinationPath);
            Files.copy(inputStream, file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error {} while writing downloaded file to location {} ", (Object)e, (Object)destinationPath);
            throw new SdkException("Exception encountered while downloading file", e);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
        }
        finally {
            try {
                response.consume();
            }
            catch (IOException e) {
                LOGGER.error("Error while consuming file download response ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject downloadAndReturnJSONObject(InternalExecutionContext context, String location) {
        HttpResponse<CPFContentAnalyzerResponse> response = CPFApi.cpfStatusApi(context, location, CPFContentAnalyzerResponse.class);
        MultiPartHttpResponse multiPartData = (MultiPartHttpResponse)response;
        List<MimeBodyPart> responseData = multiPartData.getResponseBodyParts();
        JSONObject pdfPropertiesJsonObject = null;
        try {
            InputStream inputStream = !response.getResponseAsStreamList().isEmpty() ? responseData.get(1).getInputStream() : null;
            ObjectMapper mapper = new ObjectMapper();
            pdfPropertiesJsonObject = new JSONObject((Map)mapper.readValue(inputStream, Map.class));
        }
        catch (IOException e) {
            LOGGER.error("Error {} while creating JSON Object", (Throwable)e);
            throw new SdkException("Exception encountered while creating JSON Object ", e);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
        }
        finally {
            try {
                response.consume();
            }
            catch (IOException e) {
                LOGGER.error("Error while consuming file download response ", (Throwable)e);
            }
        }
        return pdfPropertiesJsonObject;
    }
}

