/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal;

import com.adobe.pdfservices.operation.ClientConfig;
import com.adobe.pdfservices.operation.ExecutionContext;
import com.adobe.pdfservices.operation.auth.Credentials;
import com.adobe.pdfservices.operation.auth.ServiceAccountCredentials;
import com.adobe.pdfservices.operation.internal.CPFServiceRequestContext;
import com.adobe.pdfservices.operation.internal.InternalClientConfig;
import com.adobe.pdfservices.operation.internal.auth.Authenticator;
import com.adobe.pdfservices.operation.internal.auth.AuthenticatorFactory;
import com.adobe.pdfservices.operation.internal.auth.ServiceAccountCredentialsWithUri;
import com.adobe.pdfservices.operation.internal.auth.SessionTokenAuthenticator;
import com.adobe.pdfservices.operation.internal.cpf.constants.RequestKey;
import com.adobe.pdfservices.operation.internal.http.HttpRequest;
import com.adobe.pdfservices.operation.internal.http.HttpRequestConfig;

public class InternalExecutionContext
extends ExecutionContext {
    private InternalClientConfig clientConfig;
    private Authenticator authenticator;
    private CPFServiceRequestContext cpfServiceRequestContext;

    public InternalExecutionContext(Credentials credentials, ClientConfig clientConfig) {
        if (!(credentials instanceof ServiceAccountCredentials)) {
            throw new IllegalArgumentException("Invalid ClientContext provided as argument");
        }
        String cpfOpsCreateUri = ((ServiceAccountCredentialsWithUri)credentials).getCpfOpsCreateUri();
        this.clientConfig = clientConfig instanceof InternalClientConfig ? (InternalClientConfig)clientConfig : new InternalClientConfig();
        this.clientConfig.validate();
        this.authenticator = AuthenticatorFactory.getAuthenticator(credentials);
        this.cpfServiceRequestContext = new CPFServiceRequestContext(cpfOpsCreateUri != null ? cpfOpsCreateUri : this.clientConfig.getOpsCreateUri());
    }

    public InternalExecutionContext(String clientId, String accessToken, String cpfUri, ClientConfig clientConfig) {
        this.authenticator = new SessionTokenAuthenticator(clientId, accessToken);
        this.clientConfig = clientConfig instanceof InternalClientConfig ? (InternalClientConfig)clientConfig : new InternalClientConfig();
        this.clientConfig.validate();
        this.cpfServiceRequestContext = new CPFServiceRequestContext(cpfUri != null ? cpfUri : this.clientConfig.getOpsCreateUri());
    }

    public InternalClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public HttpRequest getBaseRequestFromRequestContext(RequestKey requestKey) {
        HttpRequest baseRequest = this.cpfServiceRequestContext.getBaseRequest(requestKey);
        return baseRequest.withAuthenticator(this.authenticator).withConfig(new HttpRequestConfig(this.clientConfig));
    }

    public void validate() {
        this.clientConfig.validate();
        if (this.authenticator == null) {
            throw new IllegalStateException("Authentication not initialized in the provided context");
        }
    }
}

