/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.auth;

import com.adobe.pdfservices.operation.auth.Credentials;
import com.adobe.pdfservices.operation.internal.auth.ServiceAccountCredentialsWithUri;
import com.adobe.pdfservices.operation.internal.util.JsonUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotBlank;
import org.apache.commons.io.FileUtils;

public class ServiceAccountCredentials
extends Credentials {
    @NotBlank(message="client_id must not be blank")
    private @NotBlank(message="client_id must not be blank") String clientId;
    @NotBlank(message="client_secret must not be blank")
    private @NotBlank(message="client_secret must not be blank") String clientSecret;
    @NotBlank(message="private_key must not be blank")
    private @NotBlank(message="private_key must not be blank") String privateKey;
    @NotBlank(message="organization id must not be blank")
    private @NotBlank(message="organization id must not be blank") String organizationId;
    @NotBlank(message="account id must not be blank")
    private @NotBlank(message="account id must not be blank") String accountId;

    protected ServiceAccountCredentials(String clientId, String clientSecret, String privateKey, String organizationId, String accountId) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.privateKey = privateKey;
        this.organizationId = organizationId;
        this.accountId = accountId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    protected void validate() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this, new Class[0]);
        if (violations != null && !violations.isEmpty()) {
            String message = violations.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining("; "));
            throw new IllegalArgumentException(message);
        }
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private String privateKey;
        private String organizationId;
        private String accountId;
        private String imsBaseUri;
        private String claim;
        private String cpfOpsCreateUri;
        private static final String CLIENT_CREDENTIALS = "client_credentials";
        private static final String CLIENT_ID = "client_id";
        private static final String CLIENT_SECRET = "client_secret";
        private static final String SERVICE_ACCOUNT_CREDENTIALS = "service_account_credentials";
        private static final String PRIVATE_KEY_FILE = "private_key_file";
        private static final String CLAIM = "claim";
        private static final String ORGANIZATION_ID = "organization_id";
        private static final String TECHNICAL_ACCOUNT_ID = "account_id";
        private static final String IMS_BASE_URI = "ims_base_uri";
        private static final String CPF_SERVICES = "cpfServices";
        private static final String CPF_OPS_CREATE_URI = "cpfOpsCreateUri";

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder withPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder withOrganizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public Builder withAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder fromFile(String credentialsFilePath) throws IOException {
            JsonNode serviceAccountCredentials;
            File credentialsFile = new File(credentialsFilePath);
            JsonNode credentialsConfig = JsonUtil.readJsonTreeFromFile(credentialsFile);
            JsonNode clientCredentials = credentialsConfig.get(CLIENT_CREDENTIALS);
            if (clientCredentials != null) {
                JsonNode clientSecret;
                JsonNode clientId = clientCredentials.get(CLIENT_ID);
                if (clientId != null && StringUtil.isNotBlank(clientId.asText())) {
                    this.clientId = clientId.asText();
                }
                if ((clientSecret = clientCredentials.get(CLIENT_SECRET)) != null && StringUtil.isNotBlank(clientSecret.asText())) {
                    this.clientSecret = clientSecret.asText();
                }
            }
            if ((serviceAccountCredentials = credentialsConfig.get(SERVICE_ACCOUNT_CREDENTIALS)) != null) {
                JsonNode cpfOpsCreateUri;
                JsonNode cpfServices;
                JsonNode claim;
                JsonNode imsBaseUri;
                JsonNode privateKeyFileNode;
                JsonNode accountId;
                JsonNode organizationId = serviceAccountCredentials.get(ORGANIZATION_ID);
                if (organizationId != null && StringUtil.isNotBlank(organizationId.asText())) {
                    this.organizationId = organizationId.asText();
                }
                if ((accountId = serviceAccountCredentials.get(TECHNICAL_ACCOUNT_ID)) != null && StringUtil.isNotBlank(accountId.asText())) {
                    this.accountId = accountId.asText();
                }
                if ((privateKeyFileNode = serviceAccountCredentials.get(PRIVATE_KEY_FILE)) != null && StringUtil.isNotBlank(privateKeyFileNode.asText())) {
                    File privateKeyFile = new File(privateKeyFileNode.asText());
                    if (!privateKeyFile.exists()) {
                        privateKeyFile = new File(credentialsFile.getParent() + File.separator + privateKeyFileNode.asText());
                    }
                    this.privateKey = FileUtils.readFileToString((File)privateKeyFile, (Charset)StandardCharsets.UTF_8);
                }
                if ((imsBaseUri = serviceAccountCredentials.get(IMS_BASE_URI)) != null && StringUtil.isNotBlank(imsBaseUri.asText())) {
                    this.imsBaseUri = imsBaseUri.asText();
                }
                if ((claim = serviceAccountCredentials.get(CLAIM)) != null && StringUtil.isNotBlank(claim.asText())) {
                    this.claim = claim.asText();
                }
                if ((cpfServices = credentialsConfig.get(CPF_SERVICES)) != null && (cpfOpsCreateUri = cpfServices.get(CPF_OPS_CREATE_URI)) != null && StringUtil.isNotBlank(cpfOpsCreateUri.asText())) {
                    this.cpfOpsCreateUri = cpfOpsCreateUri.asText();
                }
            }
            return this;
        }

        public ServiceAccountCredentials build() {
            return new ServiceAccountCredentialsWithUri(this.imsBaseUri, this.clientId, this.clientSecret, this.privateKey, this.claim, this.organizationId, this.accountId, this.cpfOpsCreateUri);
        }
    }
}

