/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.protectpdf;

import com.adobe.pdfservices.operation.pdfops.ProtectPDFOperation;

/**
 * Supported encryption algorithms for {@link ProtectPDFOperation}
 */
public enum EncryptionAlgorithm {

    /**
     * Represents AES-128 encryption algorithm
     */
    AES_128("AES_128"),
    /**
     * Represents AES-256 encryption algorithm
     */
    AES_256("AES_256");

    private final String value;

    /**
     * Constructor.
     *
     * @param value encryption algorithm value
     */
    EncryptionAlgorithm(String value) {
        this.value = value;
    }

    /**
     * Returns the value of this encryption algorithm
     *
     * @return string value of this encryption algorithm
     */
    public String getValue() {
        return value;
    }
}
