/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.exportpdftoimages;

import com.adobe.pdfservices.operation.pdfops.ExportPDFToImagesOperation;

/**
 * Supported target formats for {@link ExportPDFToImagesOperation}
 */
public enum ExportPDFToImagesTargetFormat {

    /**
     * Represents "image/jpeg" media type
     */
    JPEG("jpeg"),
    /**
     * Represents "image/png" media type
     */
    PNG("png");


    private final String fileExt;

    /**
     * Constructor.
     *
     * @param fileExt file extension
     */
    ExportPDFToImagesTargetFormat(String fileExt) {
        this.fileExt = fileExt;
    }

    /**
     * Returns the file extension of this format
     *
     * @return file extension of this format
     */
    public String getFileExt() {
        return fileExt;
    }
}
