/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.exportpdf;

import com.adobe.pdfservices.operation.pdfops.ExportPDFOperation;

/**
 * Supported target formats for {@link ExportPDFOperation}
 */
public enum ExportPDFTargetFormat {

    /**
     * Represents "application/msword" media type
     */
    DOC("doc"),
    /**
     * Represents "application/vnd.openxmlformats-officedocument.wordprocessingml.document" media type
     */
    DOCX("docx"),
    /**
     * Represents "image/jpeg" media type
     */
    JPEG("jpeg"),
    /**
     * Represents "image/png" media type
     */
    PNG("png"),
    /**
     * Represents "application/vnd.openxmlformats-officedocument.presentationml.presentation" media type
     */
    PPTX("pptx"),
    /**
     * Represents "text/rtf" media type
     */
    RTF("rtf"),
    /**
     * Represents "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" media type
     */
    XLSX("xlsx");


    private final String fileExt;

    /**
     * Constructor.
     *
     * @param fileExt file extension
     */
    ExportPDFTargetFormat(String fileExt) {
        this.fileExt = fileExt;
    }

    /**
     * Returns the file extension of this format
     *
     * @return file extension of this format
     */
    public String getFileExt() {
        return fileExt;
    }
}
