/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.documentmerge;

import com.adobe.pdfservices.operation.pdfops.DocumentMergeOperation;
import org.json.JSONObject;

/**
 * Parameters for specifying the input JSON data and the desired output format
 * for {@link DocumentMergeOperation}.
 */
public class DocumentMergeOptions {

    private JSONObject jsonDataForMerge;

    private OutputFormat outputFormat;

    private Fragments fragments;

    /**
     * Creates a new {@code DocumentMergeOptions} instance
     * @param jsonDataForMerge JSON object specifying the input datasource for the document merge process
     * @param outputFormat target format of the generated output document
     */
    public DocumentMergeOptions(JSONObject jsonDataForMerge, OutputFormat outputFormat) {
        this.jsonDataForMerge = jsonDataForMerge;
        this.outputFormat = outputFormat;
    }

    /**
     * Creates a new {@code DocumentMergeOptions} instance
     * @param jsonDataForMerge JSON object specifying the input datasource for the document merge process
     * @param outputFormat target format of the generated output document
     * @param fragments Object for providing the fragments, List of JSON Object for resolving fragments in the input document for document merge process; Can be null or empty.
     */
    public DocumentMergeOptions(JSONObject jsonDataForMerge, OutputFormat outputFormat, Fragments fragments) {
        this.jsonDataForMerge = jsonDataForMerge;
        this.outputFormat = outputFormat;
        this.fragments = fragments;
    }

    /**
     * Represents the input datasource for the document merge process as a JSON Object
     * @return the input JSON Data to be merged with document template
     */
    public JSONObject getJsonDataForMerge() {
        return jsonDataForMerge;
    }


    /**
     * Returns the intended target format of the generated output document. Possible values are PDF and DOCX.
     * @return the output file format
     */
    public OutputFormat getOutputFormat() {
        return outputFormat;
    }

    /**
     * Returns the input fragments data for document merge process.
     * @return the fragments input data
     */
    public Fragments getFragments() { return fragments; }
}
