/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.createpdf.excel;

import com.adobe.pdfservices.operation.pdfops.CreatePDFOperation;

/**
 * Supported locales for {@link CreatePDFOperation}
 */

public enum SupportedDocumentLanguage {

  /**
   * Represents "Danish (Denmark)" locale
   */
  DA_DK("da-DK"),
  /**
   * Represents "Lithuanian (Lithuania)" locale
   */
  LT_LT("lt-LT"),
  /**
   * Represents "Slovenian (Slovenia)" locale
   */
  SL_SI("sl-SI"),
  /**
   * Represents "Greek (Greece)" locale
   */
  EL_GR("el-GR"),
  /**
   * Represents "Russian (Russia)" locale
   */
  RU_RU("ru-RU"),
  /**
   * Represents "English (United States)" locale.
   */
  EN_US("en-US"),
  /**
   * Represents "Chinese (Hong Kong)" locale
   */
  ZH_HK("zh-HK"),
  /**
   * Represents "Hungarian (Hungary)" locale
   */
  HU_HU("hu-HU"),
  /**
   * Represents "Estonian (Estonia)" locale
   */
  ET_EE("et-EE"),
  /**
   * Represents "Portuguese (Brazil)" locale
   */
  PT_BR("pt-BR"),
  /**
   * Represents "Ukrainian (Ukraine)" locale
   */
  UK_UA("uk-UA"),
  /**
   * Represents "Norwegian (Norway)" locale
   */
  NB_NO("nb-NO"),
  /**
   * Represents "Polish (Poland)" locale
   */
  PL_PL("pl-PL"),
  /**
   * Represents "Latvian (Latvia)" locale
   */
  LV_LV("lv-LV"),
  /**
   * Represents "Finnish (Finland)" locale
   */
  FI_FI("fi-FI"),
  /**
   * Represents "Japanese (Japan)" locale
   */
  JA_JP("ja-JP"),
  /**
   * Represents "Spanish (Spain)" locale
   */
  ES_ES("es-ES"),
  /**
   * Represents "Bulgarian (Bulgaria)" locale
   */
  BG_BG("bg-BG"),
  /**
   * Represents "English (United Kingdom)" locale
   */
  EN_GB("en-GB"),
  /**
   * Represents "Czech (Czech Republic)" locale
   */
  CS_CZ("cs-CZ"),
  /**
   * Represents "Maltese (Malta)" locale
   */
  MT_MT("mt-MT"),
  /**
   * Represents "German (Germany)" locale
   */
  DE_DE("de-DE"),
  /**
   * Represents "Croatian (Croatia)" locale
   */
  HR_HR("hr-HR"),
  /**
   * Represents "Slovak (Slovakia)" locale
   */
  SK_SK("sk-SK"),
  /**
   * Represents "Serbian (Serbia)" locale
   */
  SR_SR("sr-SR"),
  /**
   * Represents "Catalan (Canada)" locale
   */
  CA_CA("ca-CA"),
  /**
   * Represents "Macedonian (Macedonia)" locale
   */
  MK_MK("mk-MK"),
  /**
   * Represents "Korean (Korea)" locale
   */
  KO_KR("ko-KR"),
  /**
   * Represents "German (Switzerland)" locale
   */
  DE_CH("de-CH"),
  /**
   * Represents "Dutch (Netherlands)" locale
   */
  NL_NL("nl-NL"),
  /**
   * Represents "Chinese (China)" locale
   */
  ZH_CN("zh-CN"),
  /**
   * Represents "Swedish (Sweden)" locale
   */
  SV_SE("sv-SE"),
  /**
   * Represents "Italian (Italy)" locale
   */
  IT_IT("it-IT"),
  /**
   * Represents "Norwegian (Norway)" locale
   */
  NO_NO("no-NO"),
  /**
   * Represents "Turkish (Turkey)" locale
   */
  TR_TR("tr-TR"),
  /**
   * Represents "French (France)" locale
   */
  FR_FR("fr-FR"),
  /**
   * Represents "Romanian (Romania)" locale
   */
  RO_RO("ro-RO"),
  /**
   * Represents "Hebrew (Israel)" locale
   */
  IW_IL("iw-IL");

  private final String documentLanguage;

  /**
   * Construct a documentLanguage from a language code
   *
   * @param documentLanguage language code
   */
  SupportedDocumentLanguage(String documentLanguage) {
    this.documentLanguage = documentLanguage;
  }

  /**
   * Returns the language code of this SupportedDocumentLanguage
   *
   * @return language code of the documentLanguage
   */
  public String getDocumentLanguage() {
    return documentLanguage;
  }
}
