/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.createpdf;

/**
 * Class for specifying the layout of a page.
 */
public class PageLayout {

    /**
     * Default value of the page height (in inches)
     */
    private static final double DEFAULT_PAGE_HEIGHT = 11;
    /**
     * Default value of the page width (in inches)
     */
    private static final double DEFAULT_PAGE_WIDTH = 8.5;

    private double pageHeight;
    private double pageWidth;

    /**
     * Constructor to initialize a default page layout. The default layout sets
     * the height as 11 inches and width as 8.5 inches.
     */
    public PageLayout() {
        this.pageWidth = DEFAULT_PAGE_WIDTH;
        this.pageHeight = DEFAULT_PAGE_HEIGHT;
    }

    /**
     * Sets a custom page size. <br>
     * Page size and orientation can also be set using paged media CSS which overrides the SDK Page Layout settings.
     * @param pageWidth  width of the page in inches
     * @param pageHeight height of the page in inches
     */
    public void setPageSize(double pageWidth, double pageHeight) {
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
    }

    /**
     * Returns the page width in inches.
     *
     * @return page width in inches
     */
    public double getPageWidth() {
        return pageWidth;
    }

    /**
     * Returns the page height in inches.
     *
     * @return page height in inches
     */
    public double getPageHeight() {
        return pageHeight;
    }

}
