/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.createpdf;

import com.adobe.pdfservices.operation.pdfops.options.createpdf.excel.CreatePDFFromExcelOptions;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.word.CreatePDFFromWordOptions;
import com.adobe.pdfservices.operation.pdfops.CreatePDFOperation;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.ppt.CreatePDFFromPPTOptions;

/**
 * Marker base class for {@link CreatePDFOperation} options.
 * The factory methods within this class can be used to create instances of options classes corresponding to the source
 * media type.
 */
public abstract class CreatePDFOptions {

    protected CreatePDFOptions() {

    }

    /**
     * Creates a new {@code CreatePDFFromHTMLOptions} builder.
     *
     * @return a {@code CreatePDFFromHTMLOptions.Builder} instance
     */
    public static CreatePDFFromHTMLOptions.Builder htmlOptionsBuilder() {
        return new CreatePDFFromHTMLOptions.Builder();
    }

    /**
     * Creates a new {@code CreatePDFFromWordOptions} builder.
     *
     * @return a {@code CreatePDFFromWordOptions.Builder} instance
     */
    public static CreatePDFFromWordOptions.Builder wordOptionsBuilder() {
        return new CreatePDFFromWordOptions.Builder();
    }

    /**
     * Creates a new {@code CreatePDFFromExcelOptions} builder.
     *
     * @return a {@code CreatePDFFromExcelOptions.Builder} instance
     */
    public static CreatePDFFromExcelOptions.Builder excelOptionsBuilder() {
        return new CreatePDFFromExcelOptions.Builder();
    }

    /**
     * Creates a new {@code CreatePDFFromPPTOptions} builder.
     *
     * @return a {@code CreatePDFFromPPTOptions.Builder} instance
     */
    public static CreatePDFFromPPTOptions.Builder pptOptionsBuilder() {
        return new CreatePDFFromPPTOptions.Builder();
    }

}
