/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.compresspdf;

import com.adobe.pdfservices.operation.pdfops.CompressPDFOperation;

/**
 * Supported compression levels for {@link CompressPDFOperation}
 */
public enum CompressionLevel {

    /**
     * Reduces the file size of pdf by reducing resolution of the coloured and grayscale images above 100 dpi to 72 dpi (dots per inch).
     * This option uses JPEG medium quality compression.
     * Output pdf will not contain hidden layers, document structure, metadata, javascript, user properties and print settings.
     */
    HIGH("HIGH"),
    /**
     * Reduces the file size of pdf by reducing resolution of the coloured and grayscale images above 200 dpi to 144 dpi (dots per inch).
     * This option uses JP2K medium quality compression.
     */
    MEDIUM("MEDIUM"),
    /**
     * Reduces the file size of pdf by reducing resolution of the coloured and grayscale images above 250 dpi to 200 dpi (dots per inch).
     * This option uses JP2K high quality compression.
     */
    LOW("LOW");

    private final String compressionLevel;

    /**
     * Constructs Compression Level from its string representation
     *
     * @param compressionLevel String representation
     */
    CompressionLevel(String compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    /**
     * Returns the string representation of this CompressionLevel
     *
     * @return String representation of this CompressionLevel
     */
    public String getCompressionLevel(){
        return compressionLevel;
    }
}
