/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.util;

public class StringUtil {

    private static final String REQUEST_ID_UNAVAILABLE = "UnknownRequestID";

    private static final String STRING_EQUALIZER = "=";


    public static boolean isBlank(String stringToCheck) {
        return stringToCheck == null || stringToCheck.trim().length() == 0;
    }

    public static boolean isNotBlank(String stringToCheck) {
        return !isBlank(stringToCheck);
    }

    public static boolean isPositiveInteger(String stringToCheck) {
        if (StringUtil.isBlank(stringToCheck)) {
            return false;
        }
        try {
            int number = Integer.parseInt(stringToCheck);
            return number > 0;

        } catch (NumberFormatException n) {
            return false;
        }

    }

    public static boolean isEmpty(String str) {
       return str.isEmpty();
    }

    public static boolean isNull(String str) {
        return str == null;
    }

    public static String getRequestIdFromLocation(String location) {
        if(isNull(location) || isEmpty(location)) {
            return REQUEST_ID_UNAVAILABLE;
        }

        return location.split("/")[location.split("/").length - 1];
    }

    public static String getKeyFromDelimitedString(String data, String key, String deliminator) {
        if (StringUtil.isBlank(data) || StringUtil.isNull(deliminator) || StringUtil.isNull(key)) {
            return "";
        }
        String[] entries = data.split(deliminator);
        String entryDeliminator = key + STRING_EQUALIZER;
        for (String entry: entries) {
            String updated = entry.trim().replace("\"", "");
            if (updated.startsWith(entryDeliminator)) {
                return updated.substring(entryDeliminator.length()).trim();
            }
        }
        return "";
    }
}
