/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.cpf.constants.CPFConstants;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.http.DefaultRequestHeaders;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class LinearizePDFService {

    private static final String IO_FORMAT_SPECIFIER = "application/pdf";

    public static String linearizePDF(InternalExecutionContext context,
                                      FileRefImpl sourceFileRef,
                                      String operation) throws FileNotFoundException {
        try {
            // Create cpf inputs
            Inputs inputs = Inputs.builder(IO_FORMAT_SPECIFIER)
                    .build();

            // Create CPFContentAnalyzerRequests from cpf inputs and cpf outputs
            CPFContentAnalyzerRequests cpfContentAnalyzerRequests
                    = new CPFContentAnalyzerRequests(CPFConstants.LinearizePDF.PAPI_ENGINE_REPO_ASSET_ID, inputs, IO_FORMAT_SPECIFIER);

            // Prepare the sourceFileRefList
            List<FileRefImpl> sourceFileRefList = new ArrayList<>();
            sourceFileRefList.add(sourceFileRef);

            HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests,
                    sourceFileRefList, String.class, operation);

            return response.getHeaders().get(DefaultRequestHeaders.LOCATION_HEADER_NAME);
        } catch (FileNotFoundException fe) {
            throw fe;
        }
    }

}
