/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.http;

import java.util.List;
import java.util.Map;

import com.adobe.pdfservices.operation.internal.cpf.constants.RequestKey;
import com.adobe.pdfservices.operation.internal.auth.AuthenticationMethod;
import com.adobe.pdfservices.operation.internal.auth.Authenticator;
import org.apache.http.NameValuePair;
import org.apache.http.entity.StringEntity;

public interface HttpRequest {

    HttpRequest withTemplate(String uriTemplate);

    HttpRequest withContentType(String contentType);

    HttpRequest withAcceptType(String acceptHeader);

    HttpRequest withHeader(String headerName, String headerValue);

    HttpRequest withHeaders(Map<String, String> headers);

    HttpRequest withUriParam(String name, String value);

    HttpRequest withUrlEncodedFormParams(List<NameValuePair> formParams);

    HttpRequest withBody(String body);

    HttpRequest withAuthenticationMethod(AuthenticationMethod authMethod);

    /**
     * Attaches an authenticator instance to the class, which will be used for all access token operations
     *
     * @param authenticator
     * @return
     */
    HttpRequest withAuthenticator(Authenticator authenticator);

    HttpRequest withConfig(HttpRequestConfig requestConfig);

    HttpRequest withRequestKey(RequestKey requestKey);

    /**
     * Gets an access token from the authenticator configured with a request and adds it as an authorization header
     */
    void authenticate();

    /**
     * Refreshes the access token via the authenticator configured with a request and adds it as an authorization header
     */
    void forceAuthenticate();

    HttpRequestConfig getConfig();

    StringEntity getEntity();

    HttpMethod getHttpMethod();

    AuthenticationMethod getAuthMethod();

    Map<String, String> getHeaders();

    String getFinalUri();

    String getTemplateString();

    RequestType getRequestType();

    Authenticator getAuthenticator();

    RequestKey getRequestKey();
}
