/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.dto.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErrorResponse {

    private String code;
    private String message;
    private String reportErrorCode;

    @JsonCreator
    public ErrorResponse(@JsonProperty("code") String code,
                         @JsonProperty("message") String message,
                         @JsonProperty("reportErrorCode") String reportErrorCode) {
        this.code = code;
        this.message = message;
        this.reportErrorCode = reportErrorCode;
    }

    public String getCode() {
        return code;
    }

    public String getReportErrorCode() {
        return reportErrorCode;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public String toString() {
        return String.format("ErrorResponse{code='%s', message='%s', reportErrorCode='%s'}", code, message, reportErrorCode);
    }

}
