package com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.ExtractPDF;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.MultiPartFormField;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.collections4.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtractOutputMetaData {
    private List<MultiPartFormField> elementsRenditions;
    private List<MultiPartFormField> tableStructure;
    private MultiPartFormField elementsInfo;
    private MultiPartFormField info;

    private Map<String, MultiPartFormField> indexedMetaInfo;

    private void parseToIndexedMetaInfo() {
        indexedMetaInfo = new HashMap<>();
        if (this.elementsInfo  != null) {
            indexedMetaInfo.put(this.elementsInfo.getLocation(), this.elementsInfo);
        }
        if (CollectionUtils.isNotEmpty(this.elementsRenditions)) {
            for (MultiPartFormField rendition: elementsRenditions) {
                indexedMetaInfo.put(rendition.getLocation(), rendition);
            }
        }
    }
    public ExtractOutputMetaData(@JsonProperty("elementsInfo") MultiPartFormField elementsInfo,
                                 @JsonProperty("elementsRenditions") List<MultiPartFormField> elementsRenditions) {
        this.elementsInfo = elementsInfo;
        this.elementsRenditions = elementsRenditions;
        parseToIndexedMetaInfo();
    }

    public List<MultiPartFormField> getElementsRenditions() {
        return elementsRenditions;
    }

    public MultiPartFormField getElementsInfo() {
        return elementsInfo;
    }

    public Map<String, MultiPartFormField> getIndexedMetaInfo() {
        return indexedMetaInfo;
    }

}
