/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.pagemanipulation;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.adobe.pdfservices.operation.internal.options.PageRange;

@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class PageAction {

    @JsonProperty("pageRanges")
    private List<PageRange> pageRanges;

    public PageAction(List<PageRange> pageRanges) {
        this.pageRanges = pageRanges;
    }

    public List<PageRange> getPageRanges() {
        return pageRanges;
    }
}
