/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import java.util.List;

import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.adobe.pdfservices.operation.internal.options.PageRange;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SplitPDFParams implements PlatformParams {

    @JsonProperty("pageRanges")
    private List<PageRange> pageRanges;

    @JsonProperty("pageCount")
    private Integer pageCount;

    @JsonProperty("fileCount")
    private Integer fileCount;

    public SplitPDFParams(PageRanges pageRanges, Integer pageCount, Integer fileCount) {
        if (pageRanges != null)
            this.pageRanges = pageRanges.getRanges();
        this.pageCount = pageCount;
        this.fileCount = fileCount;
    }
}
