/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class Outputs {

    @JsonProperty("documentOut")
    private MultiPartFormField documentOut;

    @JsonProperty("documentOutList")
    private MultiPartFormField documentOutList;

    @JsonProperty("metadata")
    private MultiPartFormField metadata;

    public void setMetadataFrom(String outputFormat) {
        this.metadata = new MultiPartFormField(outputFormat);
    }

    public Outputs() {}

    public Outputs(String outputFormat) {
        this.documentOut = new MultiPartFormField(outputFormat);
    }

    public Outputs(String outputFormat, boolean isDocumentOutList) {
        if (isDocumentOutList) {
            this.documentOutList = new MultiPartFormField(outputFormat);
        }
        else {
            this.documentOut = new MultiPartFormField(outputFormat);
        }
    }

    public Outputs(String outputFormat, String location) {
        this.documentOut = new MultiPartFormField(outputFormat, location);
    }
}
