/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class MultiPartFormField {

    @JsonProperty("dc:format")
    private String format;

    @JsonProperty("cpf:location")
    private String location;

    public MultiPartFormField(String format) {
        this.format = format;
        this.location = "file"; // Default value
    }

    @JsonCreator
    public MultiPartFormField(@JsonProperty("dc:format") String format,
                              @JsonProperty("cpf:location") String location) {
        this.format = format;
        this.location = location;
    }

    public String getLocation() {
        return location;
    }

    public String getFormat() {
        return format;
    }

}
